/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.authenticator;

import com.okta.sdk.resource.authenticator.Authenticator;
import com.okta.sdk.resource.authenticator.AuthenticatorProvider;
import com.okta.sdk.resource.authenticator.AuthenticatorSettings;
import com.okta.sdk.resource.authenticator.AuthenticatorStatus;
import com.okta.sdk.resource.authenticator.AuthenticatorType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Authenticator
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2023-07-07T08:50:42.885-05:00")
public class DefaultAuthenticator extends AbstractInstanceResource<Authenticator> implements Authenticator {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty keyProperty = new StringProperty("key");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static ResourceReference<AuthenticatorProvider> providerProperty = new ResourceReference("provider", AuthenticatorProvider.class, false);
    private final static ResourceReference<AuthenticatorSettings> settingsProperty = new ResourceReference("settings", AuthenticatorSettings.class, false);
    private final static EnumProperty<AuthenticatorStatus> statusProperty = new EnumProperty("status", AuthenticatorStatus.class);
    private final static EnumProperty<AuthenticatorType> typeProperty = new EnumProperty("type", AuthenticatorType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, createdProperty, idProperty, keyProperty, lastUpdatedProperty, nameProperty, providerProperty, settingsProperty, statusProperty, typeProperty);

    public DefaultAuthenticator(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthenticator(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Authenticator.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getKey() {
        return  getString(keyProperty);
    }

    public Authenticator setKey(String key) {
        setProperty(keyProperty, key);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public Authenticator setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public AuthenticatorProvider getProvider() {
        return  getResourceProperty(providerProperty);
    }

    public Authenticator setProvider(AuthenticatorProvider provider) {
        setProperty(providerProperty, provider);
        return this;
    }

    public AuthenticatorSettings getSettings() {
        return  getResourceProperty(settingsProperty);
    }

    public Authenticator setSettings(AuthenticatorSettings settings) {
        setProperty(settingsProperty, settings);
        return this;
    }

    public AuthenticatorStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Authenticator setStatus(AuthenticatorStatus status) {
        setProperty(statusProperty, status);
        return this;
    }

    public AuthenticatorType getType() {
        return  getEnumProperty(typeProperty);
    }

    public Authenticator setType(AuthenticatorType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Success
    * @return Authenticator
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/authenticators/{authenticatorId}/lifecycle/activate")
    public Authenticator activate() {

        String authenticatorId = getId();

        hasText(authenticatorId, "'authenticatorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/authenticators/" + authenticatorId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            Authenticator.class,
            queryArgs,
            headers);

    }




    /**
    * Update Authenticator
    * Updates an authenticator
    * @return Authenticator
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/authenticators/{authenticatorId}")
    public Authenticator update() {

        String authenticatorId = getId();

        hasText(authenticatorId, "'authenticatorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authenticators/" + authenticatorId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Success
    * @return Authenticator
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/authenticators/{authenticatorId}/lifecycle/deactivate")
    public Authenticator deactivate() {

        String authenticatorId = getId();

        hasText(authenticatorId, "'authenticatorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/authenticators/" + authenticatorId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            Authenticator.class,
            queryArgs,
            headers);

    }



}
