/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.ProvisioningConnection;
import com.okta.sdk.resource.application.ProvisioningConnectionAuthScheme;
import com.okta.sdk.resource.application.ProvisioningConnectionStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * ProvisioningConnection
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2023-07-07T08:50:42.885-05:00")
public class DefaultProvisioningConnection extends AbstractInstanceResource<ProvisioningConnection> implements ProvisioningConnection {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static EnumProperty<ProvisioningConnectionAuthScheme> authSchemeProperty = new EnumProperty("authScheme", ProvisioningConnectionAuthScheme.class);
    private final static EnumProperty<ProvisioningConnectionStatus> statusProperty = new EnumProperty("status", ProvisioningConnectionStatus.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, authSchemeProperty, statusProperty);

    public DefaultProvisioningConnection(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProvisioningConnection(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ProvisioningConnection.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public ProvisioningConnectionAuthScheme getAuthScheme() {
        return  getEnumProperty(authSchemeProperty);
    }

    public ProvisioningConnection setAuthScheme(ProvisioningConnectionAuthScheme authScheme) {
        setProperty(authSchemeProperty, authScheme);
        return this;
    }

    public ProvisioningConnectionStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public ProvisioningConnection setStatus(ProvisioningConnectionStatus status) {
        setProperty(statusProperty, status);
        return this;
    }


    /**
    * Activate default Provisioning Connection for application
    * Activates the default Provisioning Connection for an application.
    * @param appId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/apps/{appId}/connections/default/lifecycle/activate")
    public void activateDefaultProvisioningConnectionForApplication(String appId) {



        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/connections/default/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Fetches the default Provisioning Connection for an application.
    * Get default Provisioning Connection for application
    * @param appId  (required)
    * @return ProvisioningConnection
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/apps/{appId}/connections/default")
    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) {



        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/connections/default",
            ProvisioningConnection.class,
            queryArgs,
            headers);
    }




    /**
    * Deactivate default Provisioning Connection for application
    * Deactivates the default Provisioning Connection for an application.
    * @param appId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/apps/{appId}/connections/default/lifecycle/deactivate")
    public void deactivateDefaultProvisioningConnectionForApplication(String appId) {



        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/connections/default/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }



}
