/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.role;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.role.Subscription;
import com.okta.sdk.resource.role.SubscriptionList;
import com.okta.sdk.resource.role.SubscriptionStatus;
import com.okta.sdk.resource.subscription.NotificationType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSubscription
extends AbstractInstanceResource<Subscription>
implements Subscription {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ListProperty channelsProperty = new ListProperty("channels");
    private static final EnumProperty<NotificationType> notificationTypeProperty = new EnumProperty<NotificationType>("notificationType", NotificationType.class);
    private static final EnumProperty<SubscriptionStatus> statusProperty = new EnumProperty<SubscriptionStatus>("status", SubscriptionStatus.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultSubscription.createPropertyDescriptorMap(linksProperty, channelsProperty, notificationTypeProperty, statusProperty);

    public DefaultSubscription(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSubscription(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Subscription.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public List<String> getChannels() {
        return this.getListProperty(channelsProperty);
    }

    public Subscription setChannels(List<String> channels) {
        this.setProperty(channelsProperty, channels);
        return this;
    }

    public NotificationType getNotificationType() {
        return this.getEnumProperty(notificationTypeProperty);
    }

    public Subscription setNotificationType(NotificationType notificationType) {
        this.setProperty(notificationTypeProperty, (Object)notificationType);
        return this;
    }

    public SubscriptionStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Subscription setStatus(SubscriptionStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Subscription getUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "", Subscription.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void subscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/subscribe", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void subscribeUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/subscribe", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SubscriptionList listRoleSubscriptions(String roleTypeOrRoleId) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions", SubscriptionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsubscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/unsubscribe", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Subscription getRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "", Subscription.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsubscribeUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/unsubscribe", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SubscriptionList listUserSubscriptions(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/subscriptions", SubscriptionList.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

