/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.trusted.origin;

import com.okta.sdk.resource.role.Scope;
import com.okta.sdk.resource.trusted.origin.TrustedOrigin;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * TrustedOrigin
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-10-11T13:51:56.108-05:00")
public class DefaultTrustedOrigin extends AbstractInstanceResource<TrustedOrigin> implements TrustedOrigin {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty createdByProperty = new StringProperty("createdBy");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty lastUpdatedByProperty = new StringProperty("lastUpdatedBy");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static StringProperty originProperty = new StringProperty("origin");
    private final static ResourceListProperty<Scope> scopesProperty = new ResourceListProperty("scopes", Scope.class);
    private final static StringProperty statusProperty = new StringProperty("status");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, createdProperty, createdByProperty, idProperty, lastUpdatedProperty, lastUpdatedByProperty, nameProperty, originProperty, scopesProperty, statusProperty);

    public DefaultTrustedOrigin(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTrustedOrigin(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return TrustedOrigin.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getCreatedBy() {
        return  getString(createdByProperty);
    }

    public TrustedOrigin setCreatedBy(String createdBy) {
        setProperty(createdByProperty, createdBy);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getLastUpdatedBy() {
        return  getString(lastUpdatedByProperty);
    }

    public TrustedOrigin setLastUpdatedBy(String lastUpdatedBy) {
        setProperty(lastUpdatedByProperty, lastUpdatedBy);
        return this;
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public TrustedOrigin setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public String getOrigin() {
        return  getString(originProperty);
    }

    public TrustedOrigin setOrigin(String origin) {
        setProperty(originProperty, origin);
        return this;
    }

    public List<Scope> getScopes() {
        return (List<Scope>) getResourceListProperty(scopesProperty);
    }

    public TrustedOrigin setScopes(List<Scope> scopes) {
        setProperty(scopesProperty, scopes);
        return this;
    }

    public String getStatus() {
        return  getString(statusProperty);
    }

    public TrustedOrigin setStatus(String status) {
        setProperty(statusProperty, status);
        return this;
    }


    /**
    * 
    * Success
    * @return TrustedOrigin
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "PUT - /api/v1/trustedOrigins/{trustedOriginId}")
    public TrustedOrigin update() {

        String trustedOriginId = getId();

        hasText(trustedOriginId, "'trustedOriginId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/trustedOrigins/" + trustedOriginId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "DELETE - /api/v1/trustedOrigins/{trustedOriginId}")
    public void delete() {

        String trustedOriginId = getId();

        hasText(trustedOriginId, "'trustedOriginId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/trustedOrigins/" + trustedOriginId + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
