/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.feature;

import com.okta.sdk.resource.common.EnabledStatus;
import com.okta.sdk.resource.feature.Feature;
import com.okta.sdk.resource.feature.FeatureList;
import com.okta.sdk.resource.feature.FeatureStage;
import com.okta.sdk.resource.feature.FeatureType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Feature
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-10-11T13:51:56.108-05:00")
public class DefaultFeature extends AbstractInstanceResource<Feature> implements Feature {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static ResourceReference<FeatureStage> stageProperty = new ResourceReference("stage", FeatureStage.class, false);
    private final static EnumProperty<EnabledStatus> statusProperty = new EnumProperty("status", EnabledStatus.class);
    private final static EnumProperty<FeatureType> typeProperty = new EnumProperty("type", FeatureType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, descriptionProperty, idProperty, nameProperty, stageProperty, statusProperty, typeProperty);

    public DefaultFeature(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultFeature(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Feature.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public Feature setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public Feature setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public FeatureStage getStage() {
        return  getResourceProperty(stageProperty);
    }

    public Feature setStage(FeatureStage stage) {
        setProperty(stageProperty, stage);
        return this;
    }

    public EnabledStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Feature setStatus(EnabledStatus status) {
        setProperty(statusProperty, status);
        return this;
    }

    public FeatureType getType() {
        return  getEnumProperty(typeProperty);
    }

    public Feature setType(FeatureType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Success
    * @param lifecycle  (required)
    * @param mode  (optional)
    * @return Feature
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "POST - /api/v1/features/{featureId}/{lifecycle}")
    public Feature updateLifecycle(String lifecycle, String mode) {

        String featureId = getId();

        hasText(featureId, "'featureId' is required and cannot be null or empty.");
        hasText(lifecycle, "'lifecycle' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (mode != null) queryArgs.put("mode", mode);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/features/" + featureId + "/" + lifecycle + "",
            new DefaultVoidResource(getDataStore()),
            this,
            Feature.class,
            queryArgs,
            headers);

    }

    /**
    * 
    * Success
    * @param lifecycle  (required)
    * @return Feature
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "POST - /api/v1/features/{featureId}/{lifecycle}")
    public Feature updateLifecycle(String lifecycle) {

        String featureId = getId();

        hasText(featureId, "'featureId' is required and cannot be null or empty.");
        hasText(lifecycle, "'lifecycle' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/features/" + featureId + "/" + lifecycle + "",
            new DefaultVoidResource(getDataStore()),
            this,
            Feature.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Success
    * @return FeatureList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "GET - /api/v1/features/{featureId}/dependencies")
    public FeatureList getDependencies() {

        String featureId = getId();

        hasText(featureId, "'featureId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/features/" + featureId + "/dependencies",
            FeatureList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return FeatureList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "GET - /api/v1/features/{featureId}/dependents")
    public FeatureList getDependents() {

        String featureId = getId();

        hasText(featureId, "'featureId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/features/" + featureId + "/dependents",
            FeatureList.class,
            queryArgs,
            headers);
    }



}
