/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.okta.sdk.impl.client;

import com.okta.commons.http.RequestExecutor;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;
import com.okta.sdk.impl.config.ClientConfiguration;

import com.okta.sdk.client.*;

import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.AppLink;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.authenticator.Authenticator;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.role.CatalogApplication;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.user.CreateUserRequest;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrMetadata;
import java.util.Date;
import com.okta.sdk.resource.domain.Domain;
import com.okta.sdk.resource.domain.DomainCertificate;
import com.okta.sdk.resource.domain.DomainListResponse;
import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.feature.Feature;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.schema.GroupSchema;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookPayload;
import com.okta.sdk.resource.inline.hook.InlineHookResponse;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JwkUse;
import com.okta.sdk.resource.linked.object.LinkedObject;
import com.okta.sdk.resource.log.LogEvent;
import com.okta.sdk.resource.network.zone.NetworkZone;
import com.okta.sdk.resource.application.OAuth2Claim;
import com.okta.sdk.resource.application.OAuth2Client;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2Scope;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.application.OAuth2Token;
import com.okta.sdk.resource.org.OrgContactTypeObj;
import com.okta.sdk.resource.org.OrgContactUser;
import com.okta.sdk.resource.org.OrgOktaCommunicationSetting;
import com.okta.sdk.resource.org.OrgOktaSupportSettingsObj;
import com.okta.sdk.resource.org.OrgPreferences;
import com.okta.sdk.resource.org.OrgSetting;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.profile.mapping.ProfileMapping;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.ResponseLinks;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.factor.SecurityQuestion;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.template.SmsTemplate;
import com.okta.sdk.resource.identity.provider.SocialAuthToken;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.threat.insight.ThreatInsightConfiguration;
import com.okta.sdk.resource.trusted.origin.TrustedOrigin;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.org.UserIdString;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import com.okta.sdk.resource.user.schema.UserSchema;
import com.okta.sdk.resource.user.type.UserType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import com.okta.sdk.resource.application.OAuth2ClaimList;
import com.okta.sdk.resource.linked.object.LinkedObjectList;
import com.okta.sdk.resource.org.OrgContactTypeObjList;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.network.zone.NetworkZoneList;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.inline.hook.InlineHookList;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.profile.mapping.ProfileMappingList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.template.SmsTemplateType;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.feature.FeatureList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.authorization.server.AuthorizationServerList;
import com.okta.sdk.resource.trusted.origin.TrustedOriginList;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.role.CatalogApplicationList;
import com.okta.sdk.resource.application.OAuth2ScopeList;
import com.okta.sdk.resource.event.hook.EventHookList;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.template.SmsTemplateList;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleList;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.user.type.UserTypeList;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicyList;
import com.okta.sdk.resource.authenticator.AuthenticatorList;
import com.okta.sdk.resource.user.ResponseLinksList;
import com.okta.sdk.resource.application.OAuth2TokenList;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.DefaultVoidResource;

import java.util.LinkedHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-10-11T13:51:56.108-05:00")
@SuppressWarnings("deprecation")
public class DefaultClient extends com.okta.sdk.impl.client.BaseClient implements com.okta.sdk.client.Client {

    /**
    * Instantiates a new Client instance that will communicate with the Okta REST API.  See the class-level
    * JavaDoc for a usage example.
    *
    * @param clientConfiguration  the {@link ClientConfiguration} containing the connection information
    * @param cacheManager         the {@link CacheManager} that should be used to cache
    */
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }

    /**
    * Instantiates a new Client instance that will communicate with the Okta REST API.  See the class-level
    * JavaDoc for a usage example.
    *
    * @param clientConfiguration  the {@link ClientConfiguration} containing the connection information
    * @param cacheManager         the {@link CacheManager} that should be used to cache
    * @param requestExecutor      the {@link RequestExecutor} that should be used to execute requests
    */
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager, RequestExecutor requestExecutor) {
        super(clientConfiguration, cacheManager, requestExecutor);
    }


    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @param q  (optional)
    * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
    * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
    * @param includeNonDeleted  (optional, default to false)
    * @return ApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/apps")
    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (expand != null) queryArgs.put("expand", expand);
        if (includeNonDeleted != null) queryArgs.put("includeNonDeleted", includeNonDeleted);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps",
            ApplicationList.class,
            queryArgs,
            headers);
    }

    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @return ApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/apps")
    public ApplicationList listApplications() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps",
            ApplicationList.class,
            queryArgs,
            headers);
    }


    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
    * @param oktaAccessGatewayAgent  (optional)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/apps")
    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) {

        notNull(application, "'application' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (activate != null) queryArgs.put("activate", activate);

        HttpHeaders headers = new HttpHeaders();
        if (oktaAccessGatewayAgent != null) headers.add("OktaAccessGateway-Agent", oktaAccessGatewayAgent);

        getDataStore().create(
            "/api/v1/apps",
            application,
            null,
            Application.class,
            queryArgs,
            headers);
        return application;

    }

    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/apps")
    public Application createApplication(Application application) {

        notNull(application, "'application' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps",
            application,
            null,
            Application.class,
            queryArgs,
            headers);
        return application;

    }


    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @param expand  (optional)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/apps/{appId}")
    public Application getApplication(String appId, String expand) {

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "",
            Application.class,
            queryArgs,
            headers);
    }

    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/apps/{appId}")
    public Application getApplication(String appId) {

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "",
            Application.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Success
    * @return AuthenticatorList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/authenticators")
    public AuthenticatorList listAuthenticators() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authenticators",
            AuthenticatorList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param authenticatorId  (required)
    * @return Authenticator
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/authenticators/{authenticatorId}")
    public Authenticator getAuthenticator(String authenticatorId) {

        hasText(authenticatorId, "'authenticatorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authenticators/" + authenticatorId + "",
            Authenticator.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param q  (optional)
    * @return AuthorizationServerList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/authorizationServers")
    public AuthorizationServerList listAuthorizationServers(String q) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers",
            AuthorizationServerList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @return AuthorizationServerList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/authorizationServers")
    public AuthorizationServerList listAuthorizationServers() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers",
            AuthorizationServerList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Success
    * @param authorizationServer  (required)
    * @return AuthorizationServer
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/authorizationServers")
    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) {

        notNull(authorizationServer, "'authorizationServer' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers",
            authorizationServer,
            null,
            AuthorizationServer.class,
            queryArgs,
            headers);
        return authorizationServer;

    }



    /**
    * 
    * Success
    * @param authServerId  (required)
    * @return AuthorizationServer
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}")
    public AuthorizationServer getAuthorizationServer(String authServerId) {

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "",
            AuthorizationServer.class,
            queryArgs,
            headers);
    }



    /**
    * List Domains
    * List all verified custom Domains for the org.
    * @return DomainListResponse
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/domains")
    public DomainListResponse listDomains() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/domains",
            DomainListResponse.class,
            queryArgs,
            headers);
    }



    /**
    * Create Domain
    * Creates your domain.
    * @param domain  (required)
    * @return Domain
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/domains")
    public Domain createDomain(Domain domain) {

        notNull(domain, "'domain' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/domains",
            domain,
            null,
            Domain.class,
            queryArgs,
            headers);
        return domain;

    }



    /**
    * Delete Domain
    * Deletes a Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/domains/{domainId}")
    public void deleteDomain(String domainId) {

        hasText(domainId, "'domainId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/domains/" + domainId + "",
            queryArgs,
            headers);
    }



    /**
    * Get Domain
    * Fetches a Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    * @return Domain
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/domains/{domainId}")
    public Domain getDomain(String domainId) {

        hasText(domainId, "'domainId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/domains/" + domainId + "",
            Domain.class,
            queryArgs,
            headers);
    }



    /**
    * Verify Domain
    * Verifies the Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    * @return Domain
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/domains/{domainId}/verify")
    public Domain verifyDomain(String domainId) {

        hasText(domainId, "'domainId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/domains/" + domainId + "/verify",
            new DefaultVoidResource(getDataStore()),
            null,
            Domain.class,
            queryArgs,
            headers);

    }



    /**
    * 
    * Success
    * @return EventHookList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/eventHooks")
    public EventHookList listEventHooks() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/eventHooks",
            EventHookList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param eventHook  (required)
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/eventHooks")
    public EventHook createEventHook(EventHook eventHook) {

        notNull(eventHook, "'eventHook' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/eventHooks",
            eventHook,
            null,
            EventHook.class,
            queryArgs,
            headers);
        return eventHook;

    }



    /**
    * 
    * Success
    * @param eventHookId  (required)
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/eventHooks/{eventHookId}")
    public EventHook getEventHook(String eventHookId) {

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/eventHooks/" + eventHookId + "",
            EventHook.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @return FeatureList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/features")
    public FeatureList listFeatures() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/features",
            FeatureList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param featureId  (required)
    * @return Feature
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/features/{featureId}")
    public Feature getFeature(String featureId) {

        hasText(featureId, "'featureId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/features/" + featureId + "",
            Feature.class,
            queryArgs,
            headers);
    }



    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @param q Searches the name property of groups for matching value (optional)
    * @param search Filter expression for groups (optional)
    * @param expand If specified, it causes additional metadata to be included in the response. (optional)
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups")
    public GroupList listGroups(String q, String search, String expand) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (search != null) queryArgs.put("search", search);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups",
            GroupList.class,
            queryArgs,
            headers);
    }

    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups")
    public GroupList listGroups() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups",
            GroupList.class,
            queryArgs,
            headers);
    }


    /**
    * Add Group
    * Adds a new group with &#x60;OKTA_GROUP&#x60; type to your organization.
    * @param group  (required)
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/groups")
    public Group createGroup(Group group) {

        notNull(group, "'group' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/groups",
            group,
            null,
            Group.class,
            queryArgs,
            headers);
        return group;

    }



    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param search Specifies the keyword to search fules for (optional)
    * @param expand If specified as &#x60;groupIdToGroupNameMap&#x60;, then show group names (optional)
    * @return GroupRuleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/rules")
    public GroupRuleList listGroupRules(String search, String expand) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (search != null) queryArgs.put("search", search);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/rules",
            GroupRuleList.class,
            queryArgs,
            headers);
    }

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @return GroupRuleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/rules")
    public GroupRuleList listGroupRules() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/rules",
            GroupRuleList.class,
            queryArgs,
            headers);
    }


    /**
    * Create Group Rule
    * Creates a group rule to dynamically add users to the specified group if they match the condition
    * @param groupRule  (required)
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/groups/rules")
    public GroupRule createGroupRule(GroupRule groupRule) {

        notNull(groupRule, "'groupRule' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/groups/rules",
            groupRule,
            null,
            GroupRule.class,
            queryArgs,
            headers);
        return groupRule;

    }



    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @param expand  (optional)
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    public GroupRule getGroupRule(String ruleId, String expand) {

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/rules/" + ruleId + "",
            GroupRule.class,
            queryArgs,
            headers);
    }

    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    public GroupRule getGroupRule(String ruleId) {

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/rules/" + ruleId + "",
            GroupRule.class,
            queryArgs,
            headers);
    }


    /**
    * List Group Rules
    * Fetches a group from your organization.
    * @param groupId  (required)
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}")
    public Group getGroup(String groupId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "",
            Group.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param expand  (optional)
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles")
    public RoleList listGroupAssignedRoles(String groupId, String expand) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/roles",
            RoleList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @param groupId  (required)
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles")
    public RoleList listGroupAssignedRoles(String groupId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/roles",
            RoleList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Unassigns a Role from a Group
    * @param groupId  (required)
    * @param roleId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}")
    public void removeRoleFromGroup(String groupId, String roleId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "",
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}")
    public Role getRole(String groupId, String roleId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "",
            Role.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a Group. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
    * @param groupId  (required)
    * @param roleId  (required)
    * @return CatalogApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps")
    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps",
            CatalogApplicationList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}")
    public void removeApplicationTargetFromApplicationAdministratorRoleGivenToGroup(String groupId, String roleId, String appName) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "",
            queryArgs,
            headers);
    }



    /**
    * Remove App Instance Target to App Administrator Role given to a Group
    * Remove App Instance Target to App Administrator Role given to a Group
    * @param groupId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    public void removeApplicationTargetFromAdministratorRoleGivenToGroup(String groupId, String roleId, String appName, String applicationId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");
        hasText(applicationId, "'applicationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "",
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}/targets/groups")
    public GroupList listGroupTargetsForGroupRole(String groupId, String roleId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups",
            GroupList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * 
    * @param groupId  (required)
    * @param roleId  (required)
    * @param targetGroupId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}")
    public void removeGroupTargetFromGroupAdministratorRoleGivenToGroup(String groupId, String roleId, String targetGroupId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(targetGroupId, "'targetGroupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "",
            queryArgs,
            headers);
    }



    /**
    * List Identity Providers
    * Enumerates IdPs in your organization with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
    * @param q Searches the name property of IdPs for matching value (optional)
    * @param type Filters IdPs by type (optional)
    * @return IdentityProviderList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/idps")
    public IdentityProviderList listIdentityProviders(String q, String type) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (type != null) queryArgs.put("type", type);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps",
            IdentityProviderList.class,
            queryArgs,
            headers);
    }

    /**
    * List Identity Providers
    * Enumerates IdPs in your organization with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
    * @return IdentityProviderList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/idps")
    public IdentityProviderList listIdentityProviders() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps",
            IdentityProviderList.class,
            queryArgs,
            headers);
    }


    /**
    * Add Identity Provider
    * Adds a new IdP to your organization.
    * @param identityProvider  (required)
    * @return IdentityProvider
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/idps")
    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) {

        notNull(identityProvider, "'identityProvider' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/idps",
            identityProvider,
            null,
            IdentityProvider.class,
            queryArgs,
            headers);
        return identityProvider;

    }



    /**
    * List Keys
    * Enumerates IdP key credentials.
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/idps/credentials/keys")
    public JsonWebKeyList listIdentityProviderKeys() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/credentials/keys",
            JsonWebKeyList.class,
            queryArgs,
            headers);
    }



    /**
    * Add X.509 Certificate Public Key
    * Adds a new X.509 certificate credential to the IdP key store.
    * @param jsonWebKey  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/idps/credentials/keys")
    public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey) {

        notNull(jsonWebKey, "'jsonWebKey' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/idps/credentials/keys",
            jsonWebKey,
            null,
            JsonWebKey.class,
            queryArgs,
            headers);
        return jsonWebKey;

    }



    /**
    * Delete Key
    * Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it is not currently being used by an Active or Inactive IdP.
    * @param keyId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/idps/credentials/keys/{keyId}")
    public void deleteIdentityProviderKey(String keyId) {

        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/idps/credentials/keys/" + keyId + "",
            queryArgs,
            headers);
    }



    /**
    * Get Key
    * Gets a specific IdP Key Credential by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/idps/credentials/keys/{keyId}")
    public JsonWebKey getIdentityProviderKey(String keyId) {

        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/credentials/keys/" + keyId + "",
            JsonWebKey.class,
            queryArgs,
            headers);
    }



    /**
    * Get Identity Provider
    * Fetches an IdP by &#x60;id&#x60;.
    * @param idpId  (required)
    * @return IdentityProvider
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/idps/{idpId}")
    public IdentityProvider getIdentityProvider(String idpId) {

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "",
            IdentityProvider.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
    * @param idpId  (required)
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/idps/{idpId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey apiV1IdpsIdpIdCredentialsCsrsCsrIdLifecyclePublishPost(String idpId, String csrId) {

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            null,
            JsonWebKey.class,
            queryArgs,
            headers);

    }



    /**
    * 
    * Success
    * @param type  (optional)
    * @return InlineHookList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/inlineHooks")
    public InlineHookList listInlineHooks(String type) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (type != null) queryArgs.put("type", type);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/inlineHooks",
            InlineHookList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @return InlineHookList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/inlineHooks")
    public InlineHookList listInlineHooks() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/inlineHooks",
            InlineHookList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Success
    * @param inlineHook  (required)
    * @return InlineHook
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/inlineHooks")
    public InlineHook createInlineHook(InlineHook inlineHook) {

        notNull(inlineHook, "'inlineHook' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/inlineHooks",
            inlineHook,
            null,
            InlineHook.class,
            queryArgs,
            headers);
        return inlineHook;

    }



    /**
    * 
    * Gets an inline hook by ID
    * @param inlineHookId  (required)
    * @return InlineHook
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/inlineHooks/{inlineHookId}")
    public InlineHook getInlineHook(String inlineHookId) {

        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/inlineHooks/" + inlineHookId + "",
            InlineHook.class,
            queryArgs,
            headers);
    }



    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @param since  (optional)
    * @param until  (optional)
    * @param filter  (optional)
    * @param q  (optional)
    * @param sortOrder  (optional, default to ASCENDING)
    * @return LogEventList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/logs")
    public LogEventList getLogs(Date since, Date until, String filter, String q, String sortOrder) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (since != null) queryArgs.put("since", since);
        if (until != null) queryArgs.put("until", until);
        if (filter != null) queryArgs.put("filter", filter);
        if (q != null) queryArgs.put("q", q);
        if (sortOrder != null) queryArgs.put("sortOrder", sortOrder);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/logs",
            LogEventList.class,
            queryArgs,
            headers);
    }

    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @return LogEventList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/logs")
    public LogEventList getLogs() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/logs",
            LogEventList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Enumerates Profile Mappings in your organization with pagination.
    * @param sourceId  (optional)
    * @param targetId  (optional, default to )
    * @return ProfileMappingList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/mappings")
    public ProfileMappingList listProfileMappings(String sourceId, String targetId) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (sourceId != null) queryArgs.put("sourceId", sourceId);
        if (targetId != null) queryArgs.put("targetId", targetId);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/mappings",
            ProfileMappingList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Enumerates Profile Mappings in your organization with pagination.
    * @return ProfileMappingList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/mappings")
    public ProfileMappingList listProfileMappings() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/mappings",
            ProfileMappingList.class,
            queryArgs,
            headers);
    }


    /**
    * Get Profile Mapping
    * Fetches a single Profile Mapping referenced by its ID.
    * @param mappingId  (required)
    * @return ProfileMapping
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/mappings/{mappingId}")
    public ProfileMapping getProfileMapping(String mappingId) {

        hasText(mappingId, "'mappingId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/mappings/" + mappingId + "",
            ProfileMapping.class,
            queryArgs,
            headers);
    }



    /**
    * Fetches the Schema for an App User
    * Fetches the Schema for an App User
    * @param appInstanceId  (required)
    * @return UserSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    public UserSchema getApplicationUserSchema(String appInstanceId) {

        hasText(appInstanceId, "'appInstanceId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/schemas/apps/" + appInstanceId + "/default",
            UserSchema.class,
            queryArgs,
            headers);
    }



    /**
    * Partial updates on the User Profile properties of the Application User Schema.
    * Partial updates on the User Profile properties of the Application User Schema.
    * @param appInstanceId  (required)
    * @param body  (optional)
    * @return UserSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    public UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body) {

        hasText(appInstanceId, "'appInstanceId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/meta/schemas/apps/" + appInstanceId + "/default",
            body,
            null,
            UserSchema.class,
            queryArgs,
            headers);
        return body;

    }

    /**
    * Partial updates on the User Profile properties of the Application User Schema.
    * Partial updates on the User Profile properties of the Application User Schema.
    * @param appInstanceId  (required)
    * @return UserSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    public UserSchema updateApplicationUserProfile(String appInstanceId) {

        hasText(appInstanceId, "'appInstanceId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/meta/schemas/apps/" + appInstanceId + "/default",
            new DefaultVoidResource(getDataStore()),
            null,
            UserSchema.class,
            queryArgs,
            headers);
    }


    /**
    * Fetches the group schema
    * Fetches the group schema
    * @return GroupSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/schemas/group/default")
    public GroupSchema getGroupSchema() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/schemas/group/default",
            GroupSchema.class,
            queryArgs,
            headers);
    }



    /**
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * @param body  (optional)
    * @return GroupSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/group/default")
    public GroupSchema updateGroupSchema(GroupSchema body) {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/meta/schemas/group/default",
            body,
            null,
            GroupSchema.class,
            queryArgs,
            headers);
        return body;

    }

    /**
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * @return GroupSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/group/default")
    public GroupSchema updateGroupSchema() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/meta/schemas/group/default",
            new DefaultVoidResource(getDataStore()),
            null,
            GroupSchema.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Success
    * @return LinkedObjectList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/schemas/user/linkedObjects")
    public LinkedObjectList listLinkedObjectDefinitions() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/schemas/user/linkedObjects",
            LinkedObjectList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param linkedObject  (required)
    * @return LinkedObject
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/user/linkedObjects")
    public LinkedObject addLinkedObjectDefinition(LinkedObject linkedObject) {

        notNull(linkedObject, "'linkedObject' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/meta/schemas/user/linkedObjects",
            linkedObject,
            null,
            LinkedObject.class,
            queryArgs,
            headers);
        return linkedObject;

    }



    /**
    * 
    * Success
    * @param linkedObjectName  (required)
    * @return LinkedObject
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}")
    public LinkedObject getLinkedObjectDefinition(String linkedObjectName) {

        hasText(linkedObjectName, "'linkedObjectName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "",
            LinkedObject.class,
            queryArgs,
            headers);
    }



    /**
    * Fetches the schema for a Schema Id.
    * Fetches the schema for a Schema Id.
    * @param schemaId  (required)
    * @return UserSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/schemas/user/{schemaId}")
    public UserSchema getUserSchema(String schemaId) {

        hasText(schemaId, "'schemaId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/schemas/user/" + schemaId + "",
            UserSchema.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Partial updates on the User Profile properties of the user schema.
    * @param schemaId  (required)
    * @param userSchema  (required)
    * @return UserSchema
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/schemas/user/{schemaId}")
    public UserSchema updateUserProfile(String schemaId, UserSchema userSchema) {

        notNull(userSchema, "'userSchema' is required and cannot be null.");
        hasText(schemaId, "'schemaId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/meta/schemas/user/" + schemaId + "",
            userSchema,
            null,
            UserSchema.class,
            queryArgs,
            headers);
        return userSchema;

    }



    /**
    * 
    * Fetches all User Types in your org
    * @return UserTypeList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/types/user")
    public UserTypeList listUserTypes() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/types/user",
            UserTypeList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Creates a new User Type. A default User Type is automatically created along with your org, and you may add another 9 User Types for a maximum of 10.
    * @param userType  (required)
    * @return UserType
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/meta/types/user")
    public UserType createUserType(UserType userType) {

        notNull(userType, "'userType' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/meta/types/user",
            userType,
            null,
            UserType.class,
            queryArgs,
            headers);
        return userType;

    }



    /**
    * 
    * Fetches a User Type by ID. The special identifier &#x60;default&#x60; may be used to fetch the default User Type.
    * @param typeId  (required)
    * @return UserType
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/meta/types/user/{typeId}")
    public UserType getUserType(String typeId) {

        hasText(typeId, "'typeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/meta/types/user/" + typeId + "",
            UserType.class,
            queryArgs,
            headers);
    }



    /**
    * Get org settings
    * Get settings of your organization.
    * @return OrgSetting
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org")
    public OrgSetting getOrgSettings() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org",
            OrgSetting.class,
            queryArgs,
            headers);
    }



    /**
    * Get org contact types
    * Gets Contact Types of your organization.
    * @return OrgContactTypeObjList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org/contacts")
    public OrgContactTypeObjList getOrgContactTypes() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/contacts",
            OrgContactTypeObjList.class,
            queryArgs,
            headers);
    }



    /**
    * Get org contact user
    * Retrieves the URL of the User associated with the specified Contact Type.
    * @param contactType  (required)
    * @return OrgContactUser
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org/contacts/{contactType}")
    public OrgContactUser getOrgContactUser(String contactType) {

        hasText(contactType, "'contactType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/contacts/" + contactType + "",
            OrgContactUser.class,
            queryArgs,
            headers);
    }



    /**
    * Get org preferences
    * Gets preferences of your organization.
    * @return OrgPreferences
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org/preferences")
    public OrgPreferences getOrgPreferences() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/preferences",
            OrgPreferences.class,
            queryArgs,
            headers);
    }



    /**
    * Get Okta Communication Settings
    * Gets Okta Communication Settings of your organization.
    * @return OrgOktaCommunicationSetting
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org/privacy/oktaCommunication")
    public OrgOktaCommunicationSetting getOktaCommunicationSettings() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/privacy/oktaCommunication",
            OrgOktaCommunicationSetting.class,
            queryArgs,
            headers);
    }



    /**
    * Get Okta Support settings
    * Gets Okta Support Settings of your organization.
    * @return OrgOktaSupportSettingsObj
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/org/privacy/oktaSupport")
    public OrgOktaSupportSettingsObj getOrgOktaSupportSettings() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/privacy/oktaSupport",
            OrgOktaSupportSettingsObj.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Gets all policies with the specified type.
    * @param type  (required)
    * @param status  (optional)
    * @param expand  (optional, default to )
    * @return PolicyList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/policies")
    public PolicyList listPolicies(String type, String status, String expand) {

        notNull(type, "'type' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (type != null) queryArgs.put("type", type);
        if (status != null) queryArgs.put("status", status);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies",
            PolicyList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Gets all policies with the specified type.
    * @param type  (required)
    * @return PolicyList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/policies")
    public PolicyList listPolicies(String type) {

        notNull(type, "'type' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();
        queryArgs.put("type", type);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies",
            PolicyList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Creates a policy.
    * @param policy  (required)
    * @param activate  (optional, default to true)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/policies")
    public Policy createPolicy(Policy policy, Boolean activate) {

        notNull(policy, "'policy' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (activate != null) queryArgs.put("activate", activate);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies",
            policy,
            null,
            Policy.class,
            queryArgs,
            headers);
        return policy;

    }

    /**
    * 
    * Creates a policy.
    * @param policy  (required)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/policies")
    public Policy createPolicy(Policy policy) {

        notNull(policy, "'policy' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies",
            policy,
            null,
            Policy.class,
            queryArgs,
            headers);
        return policy;

    }


    /**
    * 
    * Gets a policy.
    * @param policyId  (required)
    * @param expand  (optional, default to )
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/policies/{policyId}")
    public Policy getPolicy(String policyId, String expand) {

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies/" + policyId + "",
            Policy.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Gets a policy.
    * @param policyId  (required)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/policies/{policyId}")
    public Policy getPolicy(String policyId) {

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies/" + policyId + "",
            Policy.class,
            queryArgs,
            headers);
    }


    /**
    * Create Session with Session Token
    * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
    * @param createSessionRequest  (required)
    * @return Session
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/sessions")
    public Session createSession(CreateSessionRequest createSessionRequest) {

        notNull(createSessionRequest, "'createSessionRequest' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/sessions",
            createSessionRequest,
            null,
            Session.class,
            queryArgs,
            headers);

    }



    /**
    * 
    * Get details about a session.
    * @param sessionId  (required)
    * @return Session
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/sessions/{sessionId}")
    public Session getSession(String sessionId) {

        hasText(sessionId, "'sessionId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/sessions/" + sessionId + "",
            Session.class,
            queryArgs,
            headers);
    }



    /**
    * List SMS Templates
    * Enumerates custom SMS templates in your organization. A subset of templates can be returned that match a template type.
    * @param templateType  (optional)
    * @return SmsTemplateList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/templates/sms")
    public SmsTemplateList listSmsTemplates(SmsTemplateType templateType) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (templateType != null) queryArgs.put("templateType", templateType);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/templates/sms",
            SmsTemplateList.class,
            queryArgs,
            headers);
    }

    /**
    * List SMS Templates
    * Enumerates custom SMS templates in your organization. A subset of templates can be returned that match a template type.
    * @return SmsTemplateList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/templates/sms")
    public SmsTemplateList listSmsTemplates() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/templates/sms",
            SmsTemplateList.class,
            queryArgs,
            headers);
    }


    /**
    * Add SMS Template
    * Adds a new custom SMS template to your organization.
    * @param smsTemplate  (required)
    * @return SmsTemplate
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/templates/sms")
    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) {

        notNull(smsTemplate, "'smsTemplate' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/templates/sms",
            smsTemplate,
            null,
            SmsTemplate.class,
            queryArgs,
            headers);
        return smsTemplate;

    }



    /**
    * Get SMS Template
    * Fetches a specific template by &#x60;id&#x60;
    * @param templateId  (required)
    * @return SmsTemplate
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/templates/sms/{templateId}")
    public SmsTemplate getSmsTemplate(String templateId) {

        hasText(templateId, "'templateId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/templates/sms/" + templateId + "",
            SmsTemplate.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Gets current ThreatInsight configuration
    * @return ThreatInsightConfiguration
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/threats/configuration")
    public ThreatInsightConfiguration getCurrentConfiguration() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/threats/configuration",
            ThreatInsightConfiguration.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param q  (optional)
    * @param filter  (optional)
    * @return TrustedOriginList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/trustedOrigins")
    public TrustedOriginList listOrigins(String q, String filter) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/trustedOrigins",
            TrustedOriginList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @return TrustedOriginList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/trustedOrigins")
    public TrustedOriginList listOrigins() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/trustedOrigins",
            TrustedOriginList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Success
    * @param trustedOrigin  (required)
    * @return TrustedOrigin
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/trustedOrigins")
    public TrustedOrigin createOrigin(TrustedOrigin trustedOrigin) {

        notNull(trustedOrigin, "'trustedOrigin' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/trustedOrigins",
            trustedOrigin,
            null,
            TrustedOrigin.class,
            queryArgs,
            headers);
        return trustedOrigin;

    }



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/trustedOrigins/{trustedOriginId}")
    public TrustedOrigin getOrigin(String trustedOriginId) {

        hasText(trustedOriginId, "'trustedOriginId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/trustedOrigins/" + trustedOriginId + "",
            TrustedOrigin.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate")
    public TrustedOrigin activateOrigin(String trustedOriginId) {

        hasText(trustedOriginId, "'trustedOriginId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            null,
            TrustedOrigin.class,
            queryArgs,
            headers);

    }



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate")
    public TrustedOrigin deactivateOrigin(String trustedOriginId) {

        hasText(trustedOriginId, "'trustedOriginId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            null,
            TrustedOrigin.class,
            queryArgs,
            headers);

    }



    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @param q Finds a user that matches firstName, lastName, and email properties (optional)
    * @param filter Filters users with a supported expression for a subset of properties (optional)
    * @param search Searches for users with a supported filtering  expression for most properties (optional)
    * @param sortBy  (optional)
    * @param sortOrder  (optional)
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users")
    public UserList listUsers(String q, String filter, String search, String sortBy, String sortOrder) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (search != null) queryArgs.put("search", search);
        if (sortBy != null) queryArgs.put("sortBy", sortBy);
        if (sortOrder != null) queryArgs.put("sortOrder", sortOrder);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users",
            UserList.class,
            queryArgs,
            headers);
    }

    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users")
    public UserList listUsers() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users",
            UserList.class,
            queryArgs,
            headers);
    }


    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
    * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
    * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional, default to )
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/users")
    public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {

        notNull(body, "'body' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (activate != null) queryArgs.put("activate", activate);
        if (provider != null) queryArgs.put("provider", provider);
        if (nextLogin != null) queryArgs.put("nextLogin", nextLogin);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users",
            body,
            null,
            User.class,
            queryArgs,
            headers);

    }

    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/users")
    public User createUser(CreateUserRequest body) {

        notNull(body, "'body' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users",
            body,
            null,
            User.class,
            queryArgs,
            headers);

    }


    /**
    * Get User
    * Fetches a user from your Okta organization.
    * @param userId  (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}")
    public User getUser(String userId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "",
            User.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Fetch a user by &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; if the short name is unambiguous.
    * @param user  (required)
    * @param userId  (required)
    * @param strict  (optional)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/users/{userId}")
    public User partialUpdateUser(User user, String userId, Boolean strict) {

        notNull(user, "'user' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (strict != null) queryArgs.put("strict", strict);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "",
            user,
            null,
            User.class,
            queryArgs,
            headers);
        return user;

    }

    /**
    * 
    * Fetch a user by &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; if the short name is unambiguous.
    * @param user  (required)
    * @param userId  (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/users/{userId}")
    public User partialUpdateUser(User user, String userId) {

        notNull(user, "'user' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "",
            user,
            null,
            User.class,
            queryArgs,
            headers);
        return user;

    }


    /**
    * 
    * Lists all grants for a specified user and client
    * @param userId  (required)
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/grants")
    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId, String expand) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all grants for a specified user and client
    * @param userId  (required)
    * @param clientId  (required)
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/grants")
    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Polls factors verification transaction for status.
    * @param userId  (required)
    * @param factorId  (required)
    * @param transactionId  (required)
    * @return VerifyUserFactorResponse
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}")
    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");
        hasText(transactionId, "'transactionId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/factors/" + factorId + "/transactions/" + transactionId + "",
            VerifyUserFactorResponse.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Gets a grant for the specified user
    * @param userId  (required)
    * @param grantId  (required)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrant
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/grants/{grantId}")
    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/grants/" + grantId + "",
            OAuth2ScopeConsentGrant.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Gets a grant for the specified user
    * @param userId  (required)
    * @param grantId  (required)
    * @return OAuth2ScopeConsentGrant
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/grants/{grantId}")
    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/grants/" + grantId + "",
            OAuth2ScopeConsentGrant.class,
            queryArgs,
            headers);
    }


    /**
    * 
    * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a User. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
    * @param userId  (required)
    * @param roleId  (required)
    * @return CatalogApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps")
    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps",
            CatalogApplicationList.class,
            queryArgs,
            headers);
    }



    /**
    * 
    * Success
    * @param userId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}")
    public void removeApplicationTargetFromApplicationAdministratorRoleForUser(String userId, String roleId, String appName) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "",
            queryArgs,
            headers);
    }



    /**
    * Remove App Instance Target to App Administrator Role given to a User
    * Remove App Instance Target to App Administrator Role given to a User
    * @param userId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    public void removeApplicationTargetFromAdministratorRoleForUser(String userId, String roleId, String appName, String applicationId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");
        hasText(applicationId, "'applicationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "",
            queryArgs,
            headers);
    }



    /**
    * List Network Zones
    * Enumerates network zones added to your organization with pagination. A subset of zones can be returned that match a supported filter expression or query.
    * @param filter Filters zones by usage or id expression (optional)
    * @return NetworkZoneList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/zones")
    public NetworkZoneList listNetworkZones(String filter) {


        Map<String, Object> queryArgs = new HashMap<>();
        if (filter != null) queryArgs.put("filter", filter);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/zones",
            NetworkZoneList.class,
            queryArgs,
            headers);
    }

    /**
    * List Network Zones
    * Enumerates network zones added to your organization with pagination. A subset of zones can be returned that match a supported filter expression or query.
    * @return NetworkZoneList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/zones")
    public NetworkZoneList listNetworkZones() {


        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/zones",
            NetworkZoneList.class,
            queryArgs,
            headers);
    }


    /**
    * Add Network Zone
    * Adds a new network zone to your Okta organization.
    * @param zone  (required)
    * @return NetworkZone
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "POST - /api/v1/zones")
    public NetworkZone createNetworkZone(NetworkZone zone) {

        notNull(zone, "'zone' is required and cannot be null.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/zones",
            zone,
            null,
            NetworkZone.class,
            queryArgs,
            headers);
        return zone;

    }



    /**
    * Get Network Zone
    * Fetches a network zone from your Okta organization by &#x60;id&#x60;.
    * @param zoneId  (required)
    * @return NetworkZone
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2021-10-11T13:51:56.108-05:00",
            comments = "GET - /api/v1/zones/{zoneId}")
    public NetworkZone getNetworkZone(String zoneId) {

        hasText(zoneId, "'zoneId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/zones/" + zoneId + "",
            NetworkZone.class,
            queryArgs,
            headers);
    }


}
