/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.group.rule;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleAction;
import com.okta.sdk.resource.group.rule.GroupRuleConditions;
import com.okta.sdk.resource.group.rule.GroupRuleStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultGroupRule
extends AbstractInstanceResource<GroupRule>
implements GroupRule {
    private static final ResourceReference<GroupRuleAction> actionsProperty = new ResourceReference<GroupRuleAction>("actions", GroupRuleAction.class, false);
    private static final ResourceReference<GroupRuleConditions> conditionsProperty = new ResourceReference<GroupRuleConditions>("conditions", GroupRuleConditions.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final EnumProperty<GroupRuleStatus> statusProperty = new EnumProperty<GroupRuleStatus>("status", GroupRuleStatus.class);
    private static final StringProperty typeProperty = new StringProperty("type");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroupRule.createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, typeProperty);

    public DefaultGroupRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroupRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return GroupRule.class;
    }

    public GroupRuleAction getActions() {
        return this.getResourceProperty(actionsProperty);
    }

    public GroupRule setActions(GroupRuleAction actions) {
        this.setProperty(actionsProperty, (Object)actions);
        return this;
    }

    public GroupRuleConditions getConditions() {
        return this.getResourceProperty(conditionsProperty);
    }

    public GroupRule setConditions(GroupRuleConditions conditions) {
        this.setProperty(conditionsProperty, (Object)conditions);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public GroupRule setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public GroupRuleStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public String getType() {
        return this.getString(typeProperty);
    }

    public GroupRule setType(String type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public void deactivate() {
        String ruleId = this.getId();
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule update() {
        String ruleId = this.getId();
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/rules/" + ruleId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    @Override
    public void delete() {
        String ruleId = this.getId();
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/rules/" + ruleId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void activate() {
        String ruleId = this.getId();
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

