/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.ResponseLinksList;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.type.UserType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUser
extends AbstractInstanceResource<User>
implements User {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty activatedProperty = new DateProperty("activated");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<UserCredentials> credentialsProperty = new ResourceReference<UserCredentials>("credentials", UserCredentials.class, false);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastLoginProperty = new DateProperty("lastLogin");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private static final ResourceReference<UserProfile> profileProperty = new ResourceReference<UserProfile>("profile", UserProfile.class, true);
    private static final EnumProperty<UserStatus> statusProperty = new EnumProperty<UserStatus>("status", UserStatus.class);
    private static final DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private static final EnumProperty<UserStatus> transitioningToStatusProperty = new EnumProperty<UserStatus>("transitioningToStatus", UserStatus.class);
    private static final ResourceReference<UserType> typeProperty = new ResourceReference<UserType>("type", UserType.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultUser.createPropertyDescriptorMap(embeddedProperty, linksProperty, activatedProperty, createdProperty, credentialsProperty, idProperty, lastLoginProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, statusProperty, statusChangedProperty, transitioningToStatusProperty, typeProperty);

    public DefaultUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return User.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getActivated() {
        return this.getDateProperty(activatedProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public UserCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public User setCredentials(UserCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastLogin() {
        return this.getDateProperty(lastLoginProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return this.getDateProperty(passwordChangedProperty);
    }

    public UserProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public User setProfile(UserProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public UserStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Date getStatusChanged() {
        return this.getDateProperty(statusChangedProperty);
    }

    public UserStatus getTransitioningToStatus() {
        return this.getEnumProperty(transitioningToStatusProperty);
    }

    public UserType getType() {
        return this.getResourceProperty(typeProperty);
    }

    public User setType(UserType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public IdentityProviderList listIdentityProviders() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ResetPasswordToken resetPassword(Boolean sendEmail) {
        String userId = this.getId();
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_password", new DefaultVoidResource(this.getDataStore()), this, ResetPasswordToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TempPassword expirePasswordAndGetTemporaryPassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password?tempPassword=true", new DefaultVoidResource(this.getDataStore()), this, TempPassword.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor enrollFactor(UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (updatePhone != null) {
            queryArgs.put("updatePhone", updatePhone);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, this, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserFactor enrollFactor(UserFactor body) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, this, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserFactorList listFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors", UserFactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPasswordGenerateOneTimeToken(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", new DefaultVoidResource(this.getDataStore()), this, ForgotPasswordResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPasswordGenerateOneTimeToken() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", new DefaultVoidResource(this.getDataStore()), this, ForgotPasswordResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void clearSessions(Boolean oAuthTokens) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (oAuthTokens != null) {
            queryArgs.put("oauthTokens", oAuthTokens);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public void clearSessions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAllAppsAsTarget(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user, Boolean sendEmail) {
        String userId = this.getId();
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", user, this, ForgotPasswordResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user) {
        String userId = this.getId();
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", user, this, ForgotPasswordResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeTokensForUserAndClient(String clientId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public void resetFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_factors", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ResponseLinksList getLinkedObjects(String relationshipName) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)relationshipName, (String)"'relationshipName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "", ResponseLinksList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeGrants() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/grants", queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroupTargets(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId, String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeGrantsForUserAndClient(String clientId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeRole(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeTokenForUserAndClient(String clientId, String tokenId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public User expirePassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password?tempPassword=false", new DefaultVoidResource(this.getDataStore()), this, User.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken activate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials) {
        String userId = this.getId();
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_recovery_question", userCredentials, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userCredentials;
    }

    public OAuth2ScopeConsentGrantList listGrants(String scopeId, String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (scopeId != null) {
            queryArgs.put("scopeId", scopeId);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listGrants() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsuspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unsuspend", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRole(AssignRoleRequest assignRoleRequest, String disableNotifications) {
        String userId = this.getId();
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (disableNotifications != null) {
            queryArgs.put("disableNotifications", disableNotifications);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/roles", assignRoleRequest, this, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRole(AssignRoleRequest assignRoleRequest) {
        String userId = this.getId();
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/roles", assignRoleRequest, this, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId, String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeGroupTarget(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactorList listSupportedFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/catalog", UserFactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void delete(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ClientList listClients() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients", OAuth2ClientList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void suspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/suspend", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeGrant(String grantId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/grants/" + grantId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void setLinkedObject(String primaryRelationshipName, String primaryUserId) {
        String associatedUserId = this.getId();
        Assert.hasText((String)associatedUserId, (String)"'associatedUserId' is required and cannot be null or empty.");
        Assert.hasText((String)primaryRelationshipName, (String)"'primaryRelationshipName' is required and cannot be null or empty.");
        Assert.hasText((String)primaryUserId, (String)"'primaryUserId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + associatedUserId + "/linkedObjects/" + primaryRelationshipName + "/" + primaryUserId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeLinkedObject(String relationshipName) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)relationshipName, (String)"'relationshipName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void unlock() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unlock", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User update(Boolean strict) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public User update() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public void deleteFactor(String factorId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/factors/" + factorId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken reactivate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reactivate", new DefaultVoidResource(this.getDataStore()), this, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken reactivate() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reactivate", new DefaultVoidResource(this.getDataStore()), this, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor getFactor(String factorId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/" + factorId + "", UserFactor.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, Boolean strict) {
        String userId = this.getId();
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest) {
        String userId = this.getId();
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public AppLinkList listAppLinks() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/appLinks", AppLinkList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addGroupTarget(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public SecurityQuestionList listSupportedSecurityQuestions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/questions", SecurityQuestionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addToGroup(String groupId) {
        String userId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listAssignedRoles(String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listAssignedRoles() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

