/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.3.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.identity.provider;

import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.identity.provider.Protocol;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.policy.IdentityProviderPolicy;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * IdentityProvider
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-03-30T11:57:40.442-07:00")
public class DefaultIdentityProvider extends AbstractInstanceResource<IdentityProvider> implements IdentityProvider {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static EnumProperty<IssuerModeEnum> issuerModeProperty = new EnumProperty("issuerMode", IssuerModeEnum.class);
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static ResourceReference<IdentityProviderPolicy> policyProperty = new ResourceReference("policy", IdentityProviderPolicy.class, false);
    private final static ResourceReference<Protocol> protocolProperty = new ResourceReference("protocol", Protocol.class, false);
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static EnumProperty<TypeEnum> typeProperty = new EnumProperty("type", TypeEnum.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, createdProperty, idProperty, issuerModeProperty, lastUpdatedProperty, nameProperty, policyProperty, protocolProperty, statusProperty, typeProperty);

    public DefaultIdentityProvider(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultIdentityProvider(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return IdentityProvider.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public IssuerModeEnum getIssuerMode() {
        return  getEnumProperty(issuerModeProperty);
    }

    public IdentityProvider setIssuerMode(IssuerModeEnum issuerMode) {
        setProperty(issuerModeProperty, issuerMode);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public IdentityProvider setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public IdentityProviderPolicy getPolicy() {
        return  getResourceProperty(policyProperty);
    }

    public IdentityProvider setPolicy(IdentityProviderPolicy policy) {
        setProperty(policyProperty, policy);
        return this;
    }

    public Protocol getProtocol() {
        return  getResourceProperty(protocolProperty);
    }

    public IdentityProvider setProtocol(Protocol protocol) {
        setProperty(protocolProperty, protocol);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public IdentityProvider setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }

    public TypeEnum getType() {
        return  getEnumProperty(typeProperty);
    }

    public IdentityProvider setType(TypeEnum type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Fetches a linked IdP user by ID
    * @param userId  (required)
    * @return IdentityProviderApplicationUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/users/{userId}")
    public IdentityProviderApplicationUser getUser(String userId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/users/" + userId + "",
            IdentityProviderApplicationUser.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Gets a specific Certificate Signing Request model by id
    * @param csrId  (required)
    * @return Csr
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/credentials/csrs/{csrId}")
    public Csr getSigningCsr(String csrId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "",
            Csr.class,
            queryArgs,
            headers);
    }




    /**
    * Delete Identity Provider
    * Removes an IdP from your organization.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "DELETE - /api/v1/idps/{idpId}")
    public void delete() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/idps/" + idpId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * Generate Certificate Signing Request for IdP
    * Generates a new key pair and returns a Certificate Signing Request for it.
    * @param metadata  (required)
    * @return Csr
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/credentials/csrs")
    public Csr generateCsr(CsrMetadata metadata) {

        String idpId = getId();

        notNull(metadata, "'metadata' is required and cannot be null.");
        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/credentials/csrs",
            metadata,
            this,
            Csr.class,
            queryArgs,
            headers);

    }




    /**
    * Activate Identity Provider
    * Activates an inactive IdP.
    * @return IdentityProvider
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/lifecycle/activate")
    public IdentityProvider activate() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            IdentityProvider.class,
            queryArgs,
            headers);

    }




    /**
    * Link a user to a Social IdP without a transaction
    * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
    * @param userId  (required)
    * @param userIdentityProviderLinkRequest  (required)
    * @return IdentityProviderApplicationUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/users/{userId}")
    public IdentityProviderApplicationUser linkUser(String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) {

        String idpId = getId();

        notNull(userIdentityProviderLinkRequest, "'userIdentityProviderLinkRequest' is required and cannot be null.");
        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/users/" + userId + "",
            userIdentityProviderLinkRequest,
            this,
            IdentityProviderApplicationUser.class,
            queryArgs,
            headers);

    }




    /**
    * Social Authentication Token Operation
    * Fetches the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth.
    * @param userId  (required)
    * @return SocialAuthTokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/users/{userId}/credentials/tokens")
    public SocialAuthTokenList listSocialAuthTokens(String userId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/users/" + userId + "/credentials/tokens",
            SocialAuthTokenList.class,
            queryArgs,
            headers);
    }




    /**
    * List Signing Key Credentials for IdP
    * Enumerates signing key credentials for an IdP
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/credentials/keys")
    public JsonWebKeyList listSigningKeys() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/credentials/keys",
            JsonWebKeyList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Revoke a Certificate Signing Request and delete the key pair from the IdP
    * @param csrId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "DELETE - /api/v1/idps/{idpId}/credentials/csrs/{csrId}")
    public void deleteSigningCsr(String csrId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "",
            queryArgs,
            headers);
    }




    /**
    * Get Signing Key Credential for IdP
    * Gets a specific IdP Key Credential by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/credentials/keys/{keyId}")
    public JsonWebKey getSigningKey(String keyId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "",
            JsonWebKey.class,
            queryArgs,
            headers);
    }




    /**
    * Update Identity Provider
    * Updates the configuration for an IdP.
    * @param identityProvider  (required)
    * @return IdentityProvider
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "PUT - /api/v1/idps/{idpId}")
    public IdentityProvider update(IdentityProvider identityProvider) {

        String idpId = getId();

        notNull(identityProvider, "'identityProvider' is required and cannot be null.");
        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/idps/" + idpId + "";
        getDataStore().save(href, identityProvider, this, queryArgs, headers);
        return  identityProvider;

    }




    /**
    * Generate New IdP Signing Key Credential
    * Generates a new X.509 certificate for an IdP signing key credential to be used for signing assertions sent to the IdP
    * @param validityYears expiry of the IdP Key Credential (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/credentials/keys/generate")
    public JsonWebKey generateSigningKey(Integer validityYears) {

        String idpId = getId();

        notNull(validityYears, "'validityYears' is required and cannot be null.");
        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (validityYears != null) queryArgs.put("validityYears", validityYears);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/credentials/keys/generate",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * Find Users
    * Find all the users linked to an identity provider
    * @return IdentityProviderApplicationUserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/users")
    public IdentityProviderApplicationUserList listUsers() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/users",
            IdentityProviderApplicationUserList.class,
            queryArgs,
            headers);
    }




    /**
    * Unlink User from IdP
    * Removes the link between the Okta user and the IdP user.
    * @param userId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "DELETE - /api/v1/idps/{idpId}/users/{userId}")
    public void unlinkUser(String userId) {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/idps/" + idpId + "/users/" + userId + "",
            queryArgs,
            headers);
    }




    /**
    * List Certificate Signing Requests for IdP
    * Enumerates Certificate Signing Requests for an IdP
    * @return CsrList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "GET - /api/v1/idps/{idpId}/credentials/csrs")
    public CsrList listSigningCsrs() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/idps/" + idpId + "/credentials/csrs",
            CsrList.class,
            queryArgs,
            headers);
    }




    /**
    * Deactivate Identity Provider
    * Deactivates an active IdP.
    * @return IdentityProvider
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/lifecycle/deactivate")
    public IdentityProvider deactivate() {

        String idpId = getId();

        hasText(idpId, "'idpId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            IdentityProvider.class,
            queryArgs,
            headers);

    }




    /**
    * Clone Signing Key Credential for IdP
    * Clones a X.509 certificate for an IdP signing key credential from a source IdP to target IdP
    * @param keyId  (required)
    * @param targetIdpId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "POST - /api/v1/idps/{idpId}/credentials/keys/{keyId}/clone")
    public JsonWebKey cloneKey(String keyId, String targetIdpId) {

        String idpId = getId();

        notNull(targetIdpId, "'targetIdpId' is required and cannot be null.");
        hasText(idpId, "'idpId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (targetIdpId != null) queryArgs.put("targetIdpId", targetIdpId);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "/clone",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }



}
