/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.3.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * ApplicationGroupAssignment
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-03-30T11:57:40.442-07:00")
public class DefaultApplicationGroupAssignment extends AbstractInstanceResource<ApplicationGroupAssignment> implements ApplicationGroupAssignment {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static IntegerProperty priorityProperty = new IntegerProperty("priority");
    private final static MapProperty profileProperty = new MapProperty("profile");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, idProperty, lastUpdatedProperty, priorityProperty, profileProperty);

    public DefaultApplicationGroupAssignment(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplicationGroupAssignment(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ApplicationGroupAssignment.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public Integer getPriority() {
        return  getIntProperty(priorityProperty);
    }

    public ApplicationGroupAssignment setPriority(Integer priority) {
        setProperty(priorityProperty, priority);
        return this;
    }

    public Map<String, Object> getProfile() {
        return  getMap(profileProperty);
    }

    public ApplicationGroupAssignment setProfile(Map<String, Object> profile) {
        setProperty(profileProperty, profile);
        return this;
    }


    /**
    * Remove Group from Application
    * Removes a group assignment from an application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-03-30T11:57:40.442-07:00",
          comments = "DELETE - /api/v1/apps/{appId}/groups/{groupId}")
    public void delete() {

        String groupId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/apps/{appId}/groups/{groupId}");
        String appId = pathArgs.get("appId");

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/groups/" + groupId + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
