/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.RequestExecutorFactory;
import com.okta.commons.http.config.BaseUrlResolver;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Classes;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.ds.DataStore;
import com.okta.sdk.ds.RequestBuilder;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.ds.DefaultDataStore;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.resource.Resource;

public abstract class BaseClient
implements DataStore {
    private final InternalDataStore dataStore;

    public BaseClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        Assert.notNull((Object)((Object)clientConfiguration), (String)"clientConfiguration argument cannot be null.");
        RequestExecutor requestExecutor = this.createRequestExecutor(clientConfiguration);
        this.dataStore = this.createDataStore(requestExecutor, clientConfiguration.getBaseUrlResolver(), clientConfiguration.getClientCredentialsResolver(), cacheManager);
    }

    protected InternalDataStore createDataStore(RequestExecutor requestExecutor, BaseUrlResolver baseUrlResolver, ClientCredentialsResolver clientCredentialsResolver, CacheManager cacheManager) {
        return new DefaultDataStore(requestExecutor, baseUrlResolver, clientCredentialsResolver, cacheManager);
    }

    public ClientCredentials getClientCredentials() {
        return this.dataStore.getClientCredentials();
    }

    public CacheManager getCacheManager() {
        return this.dataStore.getCacheManager();
    }

    public InternalDataStore getDataStore() {
        return this.dataStore;
    }

    protected RequestExecutor createRequestExecutor(ClientConfiguration clientConfiguration) {
        String msg = "Unable to find a '" + RequestExecutorFactory.class.getName() + "' implementation on the classpath.  Please ensure you have added the okta-sdk-httpclient.jar file to your runtime classpath.";
        return ((RequestExecutorFactory)Classes.loadFromService(RequestExecutorFactory.class, (String)msg)).create((HttpClientConfiguration)clientConfiguration);
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return (T)this.dataStore.instantiate(clazz);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return (T)this.dataStore.getResource(href, clazz);
    }

    public <T extends Resource> T create(String parentHref, T resource) {
        return this.dataStore.create(parentHref, resource);
    }

    public <T extends Resource> void save(String href, T resource) {
        this.dataStore.save(href, resource);
    }

    public <T extends Resource> void delete(String href, T resource) {
        this.dataStore.delete(href, resource);
    }

    public RequestBuilder http() {
        return this.dataStore.http();
    }
}

