/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.retry;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);
    private static final int DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final long INITIAL_BACKOFF_MS = 300L;
    private static final long RATE_LIMIT_BUFFER_MS = 1000L;
    private static final long MIN_RETRY_DELAY_MS = 1000L;
    private static final DateTimeFormatter HTTP_DATE_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME;

    static long getDefaultDelayMillis(int retries) {
        long result = (long)(Math.pow(2.0, retries) * 300.0);
        long millis = Math.min(result, 20000L);
        logger.debug("getDefaultDelayMillis: [{}]", (Object)millis);
        return millis;
    }

    static long get429DelayMillis(HttpResponse response) {
        long resetLimit = RetryUtil.getRateLimitResetValue(response);
        if (resetLimit == -1L) {
            return -1L;
        }
        Date requestDate = RetryUtil.dateFromHeader(response);
        if (requestDate == null) {
            return -1L;
        }
        long waitUntil = resetLimit * 1000L;
        long requestTime = requestDate.getTime();
        long delay = Math.max(waitUntil - requestTime + 1000L, 1000L);
        logger.debug("429 wait: Math.max({} - {} + {}ms), {}ms = {})", new Object[]{waitUntil, requestTime, 1000L, 1000L, delay});
        return delay;
    }

    static Date dateFromHeader(HttpResponse response) {
        try {
            Header dateHeader = response.getHeader("Date");
            if (dateHeader == null || TextUtils.isBlank((CharSequence)dateHeader.getValue())) {
                logger.debug("Date header is missing or empty");
                return null;
            }
            String dateValue = dateHeader.getValue();
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateValue, HTTP_DATE_FORMATTER);
            return Date.from(offsetDateTime.toInstant());
        }
        catch (ProtocolException e) {
            logger.error("Protocol error reading Date header: {}", (Object)e.getMessage());
            return null;
        }
        catch (DateTimeParseException e) {
            logger.error("Failed to parse Date header: {}", (Object)e.getMessage());
            return null;
        }
    }

    static long getRateLimitResetValue(HttpResponse response) {
        Header header = response.getFirstHeader("x-rate-limit-reset");
        return header != null && !TextUtils.isBlank((CharSequence)header.getValue()) ? Long.parseLong(header.getValue()) : -1L;
    }
}

