/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.retry;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.retry.RetryUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OktaHttpRequestRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    private static final Logger logger = LoggerFactory.getLogger(OktaHttpRequestRetryStrategy.class);
    private final int maxRetries;
    private final Set<Class<? extends IOException>> nonRetriableIOExceptionClasses;
    private final Set<Integer> retriableCodes;

    public OktaHttpRequestRetryStrategy(int maxRetries, Collection<Class<? extends IOException>> clazzes, Collection<Integer> codes) {
        Assert.isTrue((maxRetries >= 0 ? 1 : 0) != 0, (String)"maxRetries should be >= 0");
        this.maxRetries = maxRetries;
        this.nonRetriableIOExceptionClasses = new HashSet<Class<? extends IOException>>(clazzes);
        this.retriableCodes = new HashSet<Integer>(codes);
    }

    public OktaHttpRequestRetryStrategy(int maxRetries) {
        this(maxRetries, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class), Arrays.asList(429, 503, 504));
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        Class<? extends IOException> rejectException;
        Assert.notNull((Object)request, (String)"request");
        Assert.notNull((Object)exception, (String)"exception");
        if (execCount > this.maxRetries) {
            return false;
        }
        if (this.nonRetriableIOExceptionClasses.contains(exception.getClass())) {
            return false;
        }
        Iterator<Class<? extends IOException>> var5 = this.nonRetriableIOExceptionClasses.iterator();
        do {
            if (var5.hasNext()) continue;
            if (request instanceof CancellableDependency && ((CancellableDependency)request).isCancelled()) {
                return false;
            }
            return this.handleAsIdempotent(request);
        } while (!(rejectException = var5.next()).isInstance(exception));
        return false;
    }

    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        Assert.notNull((Object)response, (String)"response");
        if (this.maxRetries == 0) {
            return false;
        }
        return execCount <= this.maxRetries && this.retriableCodes.contains(response.getCode());
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Assert.notNull((Object)response, (String)"response");
        long delay = response.getCode() == 429 ? RetryUtil.get429DelayMillis(response) : RetryUtil.getDefaultDelayMillis(execCount);
        logger.info("Retry # {} after {} ms delay", (Object)execCount, (Object)delay);
        return TimeValue.of((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

