/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.resource.api.UserApi;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.AuthenticationProvider;
import com.okta.sdk.resource.model.AuthenticationProviderTypeWritable;
import com.okta.sdk.resource.model.AuthenticationProviderWritable;
import com.okta.sdk.resource.model.CreateUserRequest;
import com.okta.sdk.resource.model.CreateUserRequestType;
import com.okta.sdk.resource.model.PasswordCredential;
import com.okta.sdk.resource.model.PasswordCredentialHash;
import com.okta.sdk.resource.model.PasswordCredentialHashAlgorithm;
import com.okta.sdk.resource.model.PasswordCredentialHook;
import com.okta.sdk.resource.model.RecoveryQuestionCredential;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserCredentialsWritable;
import com.okta.sdk.resource.model.UserNextLogin;
import com.okta.sdk.resource.model.UserProfile;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUserBuilder
implements UserBuilder {
    private char[] password;
    private String securityQuestion;
    private String securityQuestionAnswer;
    private String email;
    private String login;
    private String secondEmail;
    private String firstName;
    private String lastName;
    private String middleName;
    private String honorificPrefix;
    private String honorificSuffix;
    private String title;
    private String displayName;
    private String nickName;
    private String profileUrl;
    private String primaryPhone;
    private String streetAddress;
    private String city;
    private String state;
    private String zipCode;
    private String countryCode;
    private String postalAddress;
    private String preferredLanguage;
    private String locale;
    private String timezone;
    private String employeeNumber;
    private String costCenter;
    private String organization;
    private String division;
    private String department;
    private String managerId;
    private String manager;
    private String mobilePhone;
    private Boolean active;
    private AuthenticationProvider provider;
    private String userTypeId;
    private UserNextLogin nextLogin;
    private List<String> groupIds = new ArrayList<String>();
    private Map<String, Object> passwordHashProperties;
    private String passwordHookImportType;
    private final UserProfile userProfile = new UserProfile();

    public UserBuilder setPassword(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    public UserBuilder usePasswordHookForImport() {
        return this.usePasswordHookForImport("default");
    }

    public UserBuilder usePasswordHookForImport(String type) {
        this.passwordHookImportType = type;
        return this;
    }

    public UserBuilder setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
        return this;
    }

    public UserBuilder setSecurityQuestionAnswer(String answer) {
        this.securityQuestionAnswer = answer;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public UserBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public UserBuilder setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
        return this;
    }

    public UserBuilder setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
        return this;
    }

    public UserBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public UserBuilder setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UserBuilder setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public UserBuilder setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
        return this;
    }

    public UserBuilder setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
        return this;
    }

    public UserBuilder setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    public UserBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    public UserBuilder setState(String state) {
        this.state = state;
        return this;
    }

    public UserBuilder setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public UserBuilder setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public UserBuilder setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
        return this;
    }

    public UserBuilder setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    public UserBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public UserBuilder setTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public UserBuilder setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    public UserBuilder setCostCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    public UserBuilder setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public UserBuilder setDivision(String division) {
        this.division = division;
        return this;
    }

    public UserBuilder setDepartment(String department) {
        this.department = department;
        return this;
    }

    public UserBuilder setManagerId(String managerId) {
        this.managerId = managerId;
        return this;
    }

    public UserBuilder setManager(String manager) {
        this.manager = manager;
        return this;
    }

    public UserBuilder setMiddleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public UserBuilder setLogin(String login) {
        this.login = login;
        return this;
    }

    public UserBuilder setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public UserBuilder setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
        return this;
    }

    public UserBuilder setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public UserBuilder setProvider(AuthenticationProvider provider) {
        this.provider = provider;
        return this;
    }

    public UserBuilder setType(String userTypeId) {
        this.userTypeId = userTypeId;
        return this;
    }

    public UserBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public UserBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public UserBuilder setNextLogin(UserNextLogin nextLogin) {
        this.nextLogin = nextLogin;
        return this;
    }

    private CreateUserRequest build() {
        PasswordCredential passwordCredential;
        CreateUserRequest createUserRequest = new CreateUserRequest();
        createUserRequest.setProfile(this.userProfile);
        UserProfile userProfile = createUserRequest.getProfile();
        if (Strings.hasText((String)this.firstName)) {
            userProfile.setFirstName(this.firstName);
        }
        if (Strings.hasText((String)this.lastName)) {
            userProfile.setLastName(this.lastName);
        }
        if (Strings.hasText((String)this.middleName)) {
            userProfile.setMiddleName(this.middleName);
        }
        if (Strings.hasText((String)this.honorificPrefix)) {
            userProfile.setHonorificPrefix(this.honorificPrefix);
        }
        if (Strings.hasText((String)this.honorificSuffix)) {
            userProfile.setHonorificSuffix(this.honorificSuffix);
        }
        if (Strings.hasText((String)this.title)) {
            userProfile.setTitle(this.title);
        }
        if (Strings.hasText((String)this.displayName)) {
            userProfile.setDisplayName(this.displayName);
        }
        if (Strings.hasText((String)this.nickName)) {
            userProfile.setNickName(this.nickName);
        }
        if (Strings.hasText((String)this.profileUrl)) {
            userProfile.setProfileUrl(this.profileUrl);
        }
        if (Strings.hasText((String)this.primaryPhone)) {
            userProfile.setPrimaryPhone(this.primaryPhone);
        }
        if (Strings.hasText((String)this.streetAddress)) {
            userProfile.setStreetAddress(this.streetAddress);
        }
        if (Strings.hasText((String)this.city)) {
            userProfile.setCity(this.city);
        }
        if (Strings.hasText((String)this.state)) {
            userProfile.setState(this.state);
        }
        if (Strings.hasText((String)this.zipCode)) {
            userProfile.setZipCode(this.zipCode);
        }
        if (Strings.hasText((String)this.countryCode)) {
            userProfile.setCountryCode(this.countryCode);
        }
        if (Strings.hasText((String)this.postalAddress)) {
            userProfile.setPostalAddress(this.postalAddress);
        }
        if (Strings.hasText((String)this.preferredLanguage)) {
            userProfile.setPreferredLanguage(this.preferredLanguage);
        }
        if (Strings.hasText((String)this.locale)) {
            userProfile.setLocale(this.locale);
        }
        if (Strings.hasText((String)this.timezone)) {
            userProfile.setTimezone(this.timezone);
        }
        if (Strings.hasText((String)this.employeeNumber)) {
            userProfile.setEmployeeNumber(this.employeeNumber);
        }
        if (Strings.hasText((String)this.costCenter)) {
            userProfile.setCostCenter(this.costCenter);
        }
        if (Strings.hasText((String)this.organization)) {
            userProfile.setOrganization(this.organization);
        }
        if (Strings.hasText((String)this.division)) {
            userProfile.setDivision(this.division);
        }
        if (Strings.hasText((String)this.department)) {
            userProfile.setDepartment(this.department);
        }
        if (Strings.hasText((String)this.managerId)) {
            userProfile.setManagerId(this.managerId);
        }
        if (Strings.hasText((String)this.manager)) {
            userProfile.setManager(this.manager);
        }
        if (Strings.hasText((String)this.email)) {
            userProfile.setEmail(this.email);
        }
        if (Strings.hasText((String)this.secondEmail)) {
            userProfile.setSecondEmail(this.secondEmail);
        }
        if (Strings.hasText((String)this.mobilePhone)) {
            userProfile.setMobilePhone(this.mobilePhone);
        }
        if (Strings.hasText((String)this.login)) {
            userProfile.setLogin(this.login);
        } else {
            userProfile.setLogin(this.email);
        }
        if (Strings.hasText((String)this.userTypeId)) {
            CreateUserRequestType createUserRequestType = new CreateUserRequestType();
            createUserRequestType.setId(this.userTypeId);
            createUserRequest.setType(createUserRequestType);
        }
        if (!Collections.isEmpty(this.groupIds)) {
            createUserRequest.setGroupIds(this.groupIds);
        }
        if (Strings.hasText((String)this.securityQuestion)) {
            RecoveryQuestionCredential question = new RecoveryQuestionCredential();
            question.setQuestion(this.securityQuestion);
            question.setAnswer(this.securityQuestionAnswer);
            this.createCredentialsIfNeeded(createUserRequest).setRecoveryQuestion(question);
        }
        if (this.provider != null) {
            AuthenticationProviderWritable providerWritable = new AuthenticationProviderWritable();
            providerWritable.setType(AuthenticationProviderTypeWritable.valueOf((String)this.provider.getType().name()));
            this.createCredentialsIfNeeded(createUserRequest).setProvider(providerWritable);
        }
        if (this.password != null && this.password.length > 0) {
            if (this.passwordHashProperties != null) {
                throw new IllegalArgumentException("Cannot specify both password and password hash, use one or the other.");
            }
            passwordCredential = new PasswordCredential();
            passwordCredential.setValue(new String(this.password));
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        if (this.passwordHashProperties != null) {
            passwordCredential = new PasswordCredential();
            PasswordCredentialHash passwordCredentialHash = new PasswordCredentialHash();
            passwordCredentialHash.setAlgorithm(PasswordCredentialHashAlgorithm.valueOf((String)((String)this.passwordHashProperties.get("algorithm")).replaceAll("-", "_")));
            passwordCredentialHash.setWorkFactor((Integer)this.passwordHashProperties.get("workFactor"));
            passwordCredentialHash.setSalt((String)this.passwordHashProperties.get("salt"));
            passwordCredentialHash.setValue((String)this.passwordHashProperties.get("value"));
            passwordCredentialHash.setSaltOrder((String)this.passwordHashProperties.get("saltOrder"));
            passwordCredential.setHash(passwordCredentialHash);
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        if (this.passwordHookImportType != null) {
            passwordCredential = new PasswordCredential();
            PasswordCredentialHook passwordCredentialHook = new PasswordCredentialHook();
            passwordCredentialHook.setType(this.passwordHookImportType);
            passwordCredential.setHook(passwordCredentialHook);
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        return createUserRequest;
    }

    private UserCredentialsWritable createCredentialsIfNeeded(CreateUserRequest createUserRequest) {
        if (createUserRequest.getCredentials() == null) {
            UserCredentialsWritable credentials = new UserCredentialsWritable();
            createUserRequest.setCredentials(credentials);
        }
        return createUserRequest.getCredentials();
    }

    public UserBuilder setBcryptPasswordHash(String value) {
        Assert.notNull((Object)value);
        String[] tokenizedStr = value.split("\\$");
        Assert.isTrue((tokenizedStr.length == 4 ? 1 : 0) != 0);
        int work = Integer.parseInt(tokenizedStr[2]);
        String salt = tokenizedStr[3].substring(0, 22);
        String hash = tokenizedStr[3].substring(22);
        return this.setBcryptPasswordHash(hash, salt, work);
    }

    public UserBuilder setBcryptPasswordHash(String value, String salt, int workFactor) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", "BCRYPT");
        this.passwordHashProperties.put("workFactor", workFactor);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        return this;
    }

    public UserBuilder setSha256PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-256", value, salt, saltOrder);
    }

    public UserBuilder setSha512PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-512", value, salt, saltOrder);
    }

    public UserBuilder setSha1PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-1", value, salt, saltOrder);
    }

    private UserBuilder setShaPasswordHash(String shaAlgorithm, String value, String salt, String saltOrder) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", shaAlgorithm);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        this.passwordHashProperties.put("saltOrder", saltOrder);
        return this;
    }

    public UserBuilder setCustomProfileProperty(String key, Object value) {
        this.userProfile.getAdditionalProperties().put(key, value);
        return this;
    }

    public User buildAndCreate(UserApi client) throws ApiException {
        return client.createUser(this.build(), this.active, Boolean.valueOf(this.provider != null), this.nextLogin);
    }
}

