/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.okta.sdk.resource.model.GroupProfile;
import java.io.IOException;
import java.util.Map;

public class GroupProfileDeserializer
extends StdDeserializer<GroupProfile> {
    private static final long serialVersionUID = -1809919319486559586L;
    private final ObjectMapper mapper = new ObjectMapper();

    public GroupProfileDeserializer() {
        this(null);
    }

    public GroupProfileDeserializer(Class<?> vc) {
        super(vc);
    }

    public GroupProfile deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Map profileMap = (Map)this.mapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
        GroupProfile groupProfile = new GroupProfile();
        for (Map.Entry entry : profileMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "name": {
                    groupProfile.setName((String)value);
                    break;
                }
                case "description": {
                    groupProfile.setDescription((String)value);
                    break;
                }
                case "windowsDomainQualifiedName": {
                    groupProfile.setWindowsDomainQualifiedName((String)value);
                    break;
                }
                case "dn": {
                    groupProfile.setDn((String)value);
                    break;
                }
                case "externalId": {
                    groupProfile.setExternalId((String)value);
                    break;
                }
                case "samAccountName": {
                    groupProfile.setSamAccountName((String)value);
                    break;
                }
            }
        }
        return groupProfile;
    }
}

