/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.okta.sdk.resource.model.GroupOwner;
import com.okta.sdk.resource.model.GroupOwnerOriginType;
import com.okta.sdk.resource.model.GroupOwnerType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupOwnerDeserializer
extends StdDeserializer<GroupOwner> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GroupOwnerDeserializer.class);
    private static final Set<String> ALLOWED_FIELDS = Set.of("displayName", "lastUpdated");
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private static final DateTimeFormatter NON_STANDARD_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
    private static final DateTimeFormatter NON_STANDARD_FORMATTER_SINGLE_DAY = DateTimeFormatter.ofPattern("EEE MMM  d HH:mm:ss z yyyy", Locale.ENGLISH);

    public GroupOwnerDeserializer() {
        this(null);
    }

    public GroupOwnerDeserializer(Class<?> vc) {
        super(vc);
    }

    public GroupOwner deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateStr;
        OffsetDateTime dateTime;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        GroupOwner groupOwner = new GroupOwner();
        if (this.hasNonNullValue(node, "id")) {
            groupOwner.id(node.get("id").asText());
        }
        if (this.hasNonNullValue(node, "displayName")) {
            this.setFieldValueSafe(groupOwner, "displayName", node.get("displayName").asText(), ctxt);
        }
        if (this.hasNonNullValue(node, "lastUpdated") && (dateTime = this.parseDateTime(dateStr = node.get("lastUpdated").asText())) != null) {
            this.setFieldValueSafe(groupOwner, "lastUpdated", dateTime, ctxt);
        }
        if (this.hasNonNullValue(node, "originId")) {
            groupOwner.originId(node.get("originId").asText());
        }
        if (this.hasNonNullValue(node, "originType")) {
            try {
                groupOwner.originType(GroupOwnerOriginType.fromValue((String)node.get("originType").asText()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid originType value '{}': {}", (Object)node.get("originType").asText(), (Object)e.getMessage());
            }
        }
        if (this.hasNonNullValue(node, "resolved")) {
            groupOwner.resolved(Boolean.valueOf(node.get("resolved").asBoolean()));
        }
        if (this.hasNonNullValue(node, "type")) {
            try {
                groupOwner.type(GroupOwnerType.fromValue((String)node.get("type").asText()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid type value '{}': {}", (Object)node.get("type").asText(), (Object)e.getMessage());
            }
        }
        return groupOwner;
    }

    private boolean hasNonNullValue(JsonNode node, String fieldName) {
        return node.has(fieldName) && !node.get(fieldName).isNull();
    }

    private OffsetDateTime parseDateTime(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        try {
            return OffsetDateTime.parse(dateStr);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime zdt = ZonedDateTime.parse(dateStr, NON_STANDARD_FORMATTER);
                return zdt.toOffsetDateTime();
            }
            catch (DateTimeParseException e2) {
                try {
                    ZonedDateTime zdt = ZonedDateTime.parse(dateStr, NON_STANDARD_FORMATTER_SINGLE_DAY);
                    return zdt.toOffsetDateTime();
                }
                catch (DateTimeParseException e3) {
                    logger.warn("Unable to parse date string: '{}'. Tried ISO-8601 and non-standard formats.", (Object)dateStr);
                    return null;
                }
            }
        }
    }

    private void setFieldValueSafe(Object target, String fieldName, Object value, DeserializationContext ctxt) throws JsonMappingException {
        if (!ALLOWED_FIELDS.contains(fieldName)) {
            logger.error("Attempted to set disallowed field '{}' on {}", (Object)fieldName, (Object)target.getClass().getSimpleName());
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Field not allowed: " + fieldName));
        }
        String cacheKey = target.getClass().getName() + "." + fieldName;
        try {
            Field field = FIELD_CACHE.computeIfAbsent(cacheKey, k -> {
                try {
                    Field f = target.getClass().getDeclaredField(fieldName);
                    f.setAccessible(true);
                    return f;
                }
                catch (NoSuchFieldException e) {
                    logger.error("Field '{}' not found on {}: {}", new Object[]{fieldName, target.getClass().getSimpleName(), e.getMessage()});
                    return null;
                }
            });
            if (field == null) {
                logger.error("Failed to access field '{}' on {}", (Object)fieldName, (Object)target.getClass().getSimpleName());
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Cannot access field: " + fieldName));
            }
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            logger.error("Failed to set field '{}' on {}: {}", new Object[]{fieldName, target.getClass().getSimpleName(), e.getMessage()});
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Cannot set field: " + fieldName), (Throwable)e);
        }
    }
}

