/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexibleOffsetDateTimeDeserializer
extends StdDeserializer<OffsetDateTime> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FlexibleOffsetDateTimeDeserializer.class);
    private static final DateTimeFormatter NON_STANDARD_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
    private static final DateTimeFormatter NON_STANDARD_FORMATTER_SINGLE_DAY = DateTimeFormatter.ofPattern("EEE MMM  d HH:mm:ss z yyyy", Locale.ENGLISH);

    public FlexibleOffsetDateTimeDeserializer() {
        this(null);
    }

    public FlexibleOffsetDateTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public OffsetDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateStr = jp.getText();
        return this.parseDateTime(dateStr);
    }

    private OffsetDateTime parseDateTime(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        try {
            return OffsetDateTime.parse(dateStr);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime zdt = ZonedDateTime.parse(dateStr, NON_STANDARD_FORMATTER);
                return zdt.toOffsetDateTime();
            }
            catch (DateTimeParseException e2) {
                try {
                    ZonedDateTime zdt = ZonedDateTime.parse(dateStr, NON_STANDARD_FORMATTER_SINGLE_DAY);
                    return zdt.toOffsetDateTime();
                }
                catch (DateTimeParseException e3) {
                    logger.warn("Unable to parse date string: '{}'. Tried ISO-8601 and non-standard formats.", (Object)dateStr);
                    return null;
                }
            }
        }
    }
}

