/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.resource.DefaultPolicyBuilder;
import com.okta.sdk.resource.api.PolicyApi;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.OktaSignOnPolicy;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyType;
import com.okta.sdk.resource.policy.OktaSignOnPolicyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultOktaSignOnPolicyBuilder
extends DefaultPolicyBuilder<OktaSignOnPolicyBuilder>
implements OktaSignOnPolicyBuilder {
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();

    public OktaSignOnPolicyBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public OktaSignOnPolicyBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public OktaSignOnPolicy buildAndCreate(PolicyApi client) throws ApiException {
        return (OktaSignOnPolicy)new PolicyApi(client.getApiClient()).createPolicy((Policy)this.build(), this.isActive);
    }

    private OktaSignOnPolicy build() {
        OktaSignOnPolicy policy = new OktaSignOnPolicy();
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!PolicyType.OKTA_SIGN_ON.equals((Object)this.policyType)) {
            throw new IllegalArgumentException("PolicyType should be 'OKTA_SIGN_ON', please use PolicyBuilder for other policy types.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        return policy;
    }
}

