/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksCustomRoleResponse;
import com.okta.sdk.resource.model.RoleAssignmentType;
import com.okta.sdk.resource.model.RoleType;
import com.okta.sdk.resource.model.StandardRoleEmbedded;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRoleAssignmentDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractRoleAssignmentDeserializer.class);
    private static final Set<String> ALLOWED_FIELDS = Set.of("id", "label", "created", "lastUpdated", "resourceSet", "role");
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();

    protected AbstractRoleAssignmentDeserializer(Class<?> vc) {
        super(vc);
    }

    protected abstract T createInstance();

    protected abstract void setAssignmentType(T var1, RoleAssignmentType var2);

    protected abstract void setStatus(T var1, LifecycleStatus var2);

    protected abstract void setType(T var1, RoleType var2);

    protected abstract void setEmbedded(T var1, StandardRoleEmbedded var2);

    protected abstract void setLinks(T var1, LinksCustomRoleResponse var2);

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        LinksCustomRoleResponse links;
        StandardRoleEmbedded embedded;
        OffsetDateTime lastUpdated;
        OffsetDateTime created;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        T response = this.createInstance();
        if (this.hasNonNullValue(node, "id")) {
            this.setFieldValueSafe(response, "id", node.get("id").asText(), ctxt);
        }
        if (this.hasNonNullValue(node, "label")) {
            this.setFieldValueSafe(response, "label", node.get("label").asText(), ctxt);
        }
        if (this.hasNonNullValue(node, "assignmentType")) {
            try {
                this.setAssignmentType(response, RoleAssignmentType.fromValue((String)node.get("assignmentType").asText()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid assignmentType value '{}': {}", (Object)node.get("assignmentType").asText(), (Object)e.getMessage());
            }
        }
        if (this.hasNonNullValue(node, "status")) {
            try {
                this.setStatus(response, LifecycleStatus.fromValue((String)node.get("status").asText()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid status value '{}': {}", (Object)node.get("status").asText(), (Object)e.getMessage());
            }
        }
        if (this.hasNonNullValue(node, "type")) {
            try {
                this.setType(response, RoleType.fromValue((String)node.get("type").asText()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid type value '{}': {}", (Object)node.get("type").asText(), (Object)e.getMessage());
            }
        }
        if (this.hasNonNullValue(node, "created") && (created = (OffsetDateTime)mapper.treeToValue((TreeNode)node.get("created"), OffsetDateTime.class)) != null) {
            this.setFieldValueSafe(response, "created", created, ctxt);
        }
        if (this.hasNonNullValue(node, "lastUpdated") && (lastUpdated = (OffsetDateTime)mapper.treeToValue((TreeNode)node.get("lastUpdated"), OffsetDateTime.class)) != null) {
            this.setFieldValueSafe(response, "lastUpdated", lastUpdated, ctxt);
        }
        if (this.hasNonNullValue(node, "resource-set")) {
            this.setFieldValueSafe(response, "resourceSet", node.get("resource-set").asText(), ctxt);
        }
        if (this.hasNonNullValue(node, "role")) {
            this.setFieldValueSafe(response, "role", node.get("role").asText(), ctxt);
        }
        if (this.hasNonNullValue(node, "_embedded") && (embedded = (StandardRoleEmbedded)mapper.treeToValue((TreeNode)node.get("_embedded"), StandardRoleEmbedded.class)) != null) {
            this.setEmbedded(response, embedded);
        }
        if (this.hasNonNullValue(node, "_links") && (links = (LinksCustomRoleResponse)mapper.treeToValue((TreeNode)node.get("_links"), LinksCustomRoleResponse.class)) != null) {
            this.setLinks(response, links);
        }
        return response;
    }

    protected boolean hasNonNullValue(JsonNode node, String fieldName) {
        return node.has(fieldName) && !node.get(fieldName).isNull();
    }

    protected void setFieldValueSafe(Object target, String fieldName, Object value, DeserializationContext ctxt) throws JsonMappingException {
        if (!ALLOWED_FIELDS.contains(fieldName)) {
            logger.error("Attempted to set disallowed field '{}' on {}", (Object)fieldName, (Object)target.getClass().getSimpleName());
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Field not allowed: " + fieldName));
        }
        String cacheKey = target.getClass().getName() + "." + fieldName;
        try {
            Field field = FIELD_CACHE.computeIfAbsent(cacheKey, k -> {
                try {
                    Field f = target.getClass().getDeclaredField(fieldName);
                    f.setAccessible(true);
                    return f;
                }
                catch (NoSuchFieldException e) {
                    logger.error("Field '{}' not found on {}: {}", new Object[]{fieldName, target.getClass().getSimpleName(), e.getMessage()});
                    return null;
                }
            });
            if (field == null) {
                logger.error("Failed to access field '{}' on {}", (Object)fieldName, (Object)target.getClass().getSimpleName());
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Cannot access field: " + fieldName));
            }
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            logger.error("Failed to set field '{}' on {}: {}", new Object[]{fieldName, target.getClass().getSimpleName(), e.getMessage()});
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Cannot set field: " + fieldName), (Throwable)e);
        }
    }
}

