/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

public class OAuth2AccessToken {
    public static final String TOKEN_TYPE_KEY = "token_type";
    public static final String EXPIRES_IN_KEY = "expires_in";
    public static final String ID_TOKEN_KEY = "id_token";
    public static final String ACCESS_TOKEN_KEY = "access_token";
    public static final String SCOPE_KEY = "scope";
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    private Integer expiresIn;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="id_token")
    private String idToken;
    @JsonProperty(value="scope")
    private String scope;
    private final Instant issuedAt = Instant.now();

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public boolean hasExpired() {
        return this.getExpiresAt().isBefore(Instant.now());
    }

    public Instant getExpiresAt() {
        return this.getIssuedAt().plusSeconds(this.getExpiresIn().intValue());
    }

    void expireNow() {
        this.setExpiresIn(Integer.MIN_VALUE);
    }

    public String toString() {
        return "OAuth2AccessToken [tokenType=" + this.tokenType + ", issuedAt=" + this.issuedAt + ", expiresIn=" + this.expiresIn + ", expiresAt=" + this.getExpiresAt() + ", hasExpired=" + this.hasExpired() + ", idToken=xxxxx, accessToken=xxxxx, scope=" + this.scope + "]";
    }
}

