/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.resource.DefaultApplicationBuilder;
import com.okta.sdk.resource.api.ApplicationApi;
import com.okta.sdk.resource.application.OIDCApplicationBuilder;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationCredentialsOAuthClient;
import com.okta.sdk.resource.model.ApplicationSignOnMode;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.ApplicationVisibilityHide;
import com.okta.sdk.resource.model.AutoLoginApplicationSettingsSignOn;
import com.okta.sdk.resource.model.OAuthApplicationCredentials;
import com.okta.sdk.resource.model.OAuthEndpointAuthenticationMethod;
import com.okta.sdk.resource.model.OAuthGrantType;
import com.okta.sdk.resource.model.OAuthResponseType;
import com.okta.sdk.resource.model.OpenIdConnectApplication;
import com.okta.sdk.resource.model.OpenIdConnectApplicationConsentMethod;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettings;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsClient;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsClientKeys;
import com.okta.sdk.resource.model.OpenIdConnectApplicationType;
import com.okta.sdk.resource.model.SchemasJsonWebKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultOIDCApplicationBuilder
extends DefaultApplicationBuilder<OIDCApplicationBuilder>
implements OIDCApplicationBuilder {
    private OpenIdConnectApplicationType applicationType;
    private String clientUri;
    private OpenIdConnectApplicationConsentMethod consentMethod;
    private List<OAuthGrantType> grantTypes = new ArrayList<OAuthGrantType>();
    private String logoUri;
    private String policyUri;
    private String loginUrl;
    private String redirectUrl;
    private List<String> postLogoutRedirectUris = new ArrayList<String>();
    private List<String> redirectUris = new ArrayList<String>();
    private List<OAuthResponseType> responseTypes = new ArrayList<OAuthResponseType>();
    private String tosUri;
    private String clientId;
    private String clientSecret;
    private Boolean autoKeyRotation;
    private OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod;
    private List<SchemasJsonWebKey> schemasJsonWebKeys = new ArrayList<SchemasJsonWebKey>();
    private Boolean isImplicitAssignment;
    private String inlineHookId;

    public OIDCApplicationBuilder setApplicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public OIDCApplicationBuilder setClientUri(String clientUri) {
        this.clientUri = clientUri;
        return this;
    }

    public OIDCApplicationBuilder setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
        return this;
    }

    public OIDCApplicationBuilder setGrantTypes(List<OAuthGrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OIDCApplicationBuilder addGrantTypes(OAuthGrantType grantType) {
        this.grantTypes.add(grantType);
        return this;
    }

    public OIDCApplicationBuilder setLogoUri(String logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    public OIDCApplicationBuilder setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
        return this;
    }

    public OIDCApplicationBuilder setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public OIDCApplicationBuilder setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OIDCApplicationBuilder addRedirectUris(String redirectUri) {
        this.redirectUris.add(redirectUri);
        return this;
    }

    public OIDCApplicationBuilder setResponseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public OIDCApplicationBuilder addResponseTypes(OAuthResponseType responseType) {
        this.responseTypes.add(responseType);
        return this;
    }

    public OIDCApplicationBuilder setTosUri(String tosUri) {
        this.tosUri = tosUri;
        return this;
    }

    public OIDCApplicationBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OIDCApplicationBuilder setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    public OIDCApplicationBuilder setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public OIDCApplicationBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OIDCApplicationBuilder setAutoKeyRotation(Boolean autoKeyRotation) {
        this.autoKeyRotation = autoKeyRotation;
        return this;
    }

    public OIDCApplicationBuilder setTokenEndpointAuthMethod(OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    public OIDCApplicationBuilder setJwks(List<SchemasJsonWebKey> schemasJsonWebKeys) {
        this.schemasJsonWebKeys = schemasJsonWebKeys;
        return this;
    }

    public OIDCApplicationBuilder setImplicitAssignment(Boolean isImplicitAssignment) {
        this.isImplicitAssignment = isImplicitAssignment;
        return this;
    }

    public OIDCApplicationBuilder setInlineHookId(String inlineHookId) {
        this.inlineHookId = inlineHookId;
        return this;
    }

    public OpenIdConnectApplication buildAndCreate(ApplicationApi client) throws ApiException {
        return (OpenIdConnectApplication)new ApplicationApi(client.getApiClient()).createApplication((Application)this.build(), Boolean.valueOf(false), null);
    }

    private OpenIdConnectApplication build() {
        OpenIdConnectApplication application = new OpenIdConnectApplication();
        if (Strings.hasText((String)this.label)) {
            application.setLabel(this.label);
        }
        if (Strings.hasText((String)this.name)) {
            application.setName(this.name);
        }
        application.setSignOnMode(ApplicationSignOnMode.OPENID_CONNECT);
        ApplicationAccessibility applicationAccessibility = new ApplicationAccessibility();
        if (Strings.hasText((String)this.errorRedirectUrl)) {
            applicationAccessibility.setErrorRedirectUrl(this.errorRedirectUrl);
        }
        if (Objects.nonNull(this.selfService)) {
            applicationAccessibility.setSelfService(this.selfService);
        }
        application.setAccessibility(applicationAccessibility);
        ApplicationVisibility applicationVisibility = new ApplicationVisibility();
        ApplicationVisibilityHide applicationVisibilityHide = new ApplicationVisibilityHide();
        if (Objects.nonNull(this.iOS)) {
            applicationVisibilityHide.setiOS(this.iOS);
        }
        if (Objects.nonNull(this.web)) {
            applicationVisibilityHide.setWeb(this.web);
        }
        applicationVisibility.setHide(applicationVisibilityHide);
        application.setVisibility(applicationVisibility);
        OpenIdConnectApplicationSettings openIdConnectApplicationSettings = new OpenIdConnectApplicationSettings();
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = new OpenIdConnectApplicationSettingsClient();
        if (Strings.hasText((String)this.clientUri)) {
            openIdConnectApplicationSettingsClient.setClientUri(this.clientUri);
        }
        if (Strings.hasText((String)this.logoUri)) {
            openIdConnectApplicationSettingsClient.setLogoUri(this.logoUri);
        }
        if (Strings.hasText((String)this.policyUri)) {
            openIdConnectApplicationSettingsClient.setPolicyUri(this.policyUri);
        }
        if (Strings.hasText((String)this.tosUri)) {
            openIdConnectApplicationSettingsClient.setTosUri(this.tosUri);
        }
        if (Objects.nonNull(this.postLogoutRedirectUris) && !this.postLogoutRedirectUris.isEmpty()) {
            openIdConnectApplicationSettingsClient.setPostLogoutRedirectUris(this.postLogoutRedirectUris);
        }
        if (Objects.nonNull(this.redirectUris)) {
            openIdConnectApplicationSettingsClient.setRedirectUris(this.redirectUris);
        }
        if (!Objects.nonNull(this.responseTypes) || this.responseTypes.isEmpty()) {
            throw new IllegalArgumentException("Response Type cannot be null, value should be of type OAuthResponseType");
        }
        openIdConnectApplicationSettingsClient.setResponseTypes(this.responseTypes);
        if (!Objects.nonNull(this.grantTypes) || this.grantTypes.isEmpty()) {
            throw new IllegalArgumentException("Grant Type cannot be null, value should be of type OAuthGrantType");
        }
        openIdConnectApplicationSettingsClient.setGrantTypes(this.grantTypes);
        if (Objects.nonNull(this.consentMethod)) {
            openIdConnectApplicationSettingsClient.setConsentMethod(this.consentMethod);
        }
        if (!Objects.nonNull(this.applicationType)) {
            throw new IllegalArgumentException("Application Type cannot be null, value should be of type OpenIdConnectApplicationType");
        }
        openIdConnectApplicationSettingsClient.setApplicationType(this.applicationType);
        if (Objects.nonNull(this.isImplicitAssignment)) {
            openIdConnectApplicationSettings.setImplicitAssignment(this.isImplicitAssignment);
        }
        if (Objects.nonNull(this.inlineHookId)) {
            openIdConnectApplicationSettings.setInlineHookId(this.inlineHookId);
        }
        OAuthApplicationCredentials oAuthApplicationCredentials = new OAuthApplicationCredentials();
        ApplicationCredentialsOAuthClient applicationCredentialsOAuthClient = new ApplicationCredentialsOAuthClient();
        if (Strings.hasText((String)this.clientId)) {
            applicationCredentialsOAuthClient.setClientId(this.clientId);
        }
        if (Strings.hasText((String)this.clientSecret)) {
            applicationCredentialsOAuthClient.setClientSecret(this.clientSecret);
        }
        if (Objects.nonNull(this.autoKeyRotation)) {
            applicationCredentialsOAuthClient.setAutoKeyRotation(this.autoKeyRotation);
        }
        if (!Objects.nonNull(this.tokenEndpointAuthMethod)) {
            throw new IllegalArgumentException("Token Endpoint Auth Method cannot be null, value should be of type OAuthEndpointAuthenticationMethod");
        }
        applicationCredentialsOAuthClient.setTokenEndpointAuthMethod(this.tokenEndpointAuthMethod);
        oAuthApplicationCredentials.setOauthClient(applicationCredentialsOAuthClient);
        application.setCredentials(oAuthApplicationCredentials);
        openIdConnectApplicationSettings.setOauthClient(openIdConnectApplicationSettingsClient);
        AutoLoginApplicationSettingsSignOn autoLoginApplicationSettingsSignOn = new AutoLoginApplicationSettingsSignOn();
        if (Strings.hasText((String)this.loginUrl)) {
            autoLoginApplicationSettingsSignOn.setLoginUrl(this.loginUrl);
        }
        if (Strings.hasText((String)this.redirectUrl)) {
            autoLoginApplicationSettingsSignOn.setRedirectUrl(this.redirectUrl);
        }
        if (Strings.hasText((String)autoLoginApplicationSettingsSignOn.getLoginUrl())) {
            openIdConnectApplicationSettings.setSignOn(autoLoginApplicationSettingsSignOn);
        }
        if (!this.schemasJsonWebKeys.isEmpty()) {
            OpenIdConnectApplicationSettingsClientKeys openIdConnectApplicationSettingsClientKeys = new OpenIdConnectApplicationSettingsClientKeys();
            openIdConnectApplicationSettingsClientKeys.setKeys(this.schemasJsonWebKeys);
            openIdConnectApplicationSettings.getOauthClient().setJwks(openIdConnectApplicationSettingsClientKeys);
        }
        application.setSettings(openIdConnectApplicationSettings);
        return application;
    }
}

