/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.helper.HelperUtil;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.model.Application;
import java.io.IOException;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApplicationDeserializer
extends StdDeserializer<Application> {
    private static final long serialVersionUID = 7913792877251441849L;
    private ObjectMapper objectMapper;

    public ApplicationDeserializer() {
        this(null);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new JsonNullableModule());
        this.objectMapper.setDateFormat(ApiClient.buildDefaultDateFormat());
    }

    public ApplicationDeserializer(Class<?> vc) {
        super(vc);
    }

    public Application deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Application application = (Application)this.objectMapper.convertValue((Object)node, Application.class);
        return (Application)this.objectMapper.convertValue((Object)node, HelperUtil.getApplicationType((Application)application));
    }
}

