/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.retry;

import java.util.Date;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);
    private static final int DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;

    static long getDefaultDelayMillis(int retries) {
        long scaleFactor = 300L;
        long result = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        long millis = Math.min(result, 20000L);
        logger.debug("getDefaultDelayMillis: [{}]", (Object)millis);
        return millis;
    }

    static long get429DelayMillis(HttpResponse response) {
        long resetLimit = RetryUtil.getRateLimitResetValue(response);
        if (resetLimit == -1L) {
            return -1L;
        }
        Date requestDate = RetryUtil.dateFromHeader(response);
        if (requestDate == null) {
            return -1L;
        }
        long waitUntil = resetLimit * 1000L;
        long requestTime = requestDate.getTime();
        long delay = Math.max(waitUntil - requestTime + 1000L, 1000L);
        logger.debug("429 wait: Math.max({} - {} + 1s), 1s = {})", new Object[]{waitUntil, requestTime, delay});
        return delay;
    }

    static Date dateFromHeader(HttpResponse response) {
        Date result;
        try {
            result = new Date(response.getHeader("Date").getValue());
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    static long getRateLimitResetValue(HttpResponse response) {
        Header header = response.getFirstHeader("x-rate-limit-reset");
        return header != null && !TextUtils.isBlank((CharSequence)header.getValue()) ? Long.parseLong(header.getValue()) : -1L;
    }
}

