/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.okta.commons.lang.Assert;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.OAuth2AccessToken;
import com.okta.sdk.impl.oauth2.OAuth2TokenRetrieverException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.openapitools.client.Pair;
import org.openapitools.client.auth.OAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2ClientCredentials
extends OAuth
implements ClientCredentials<OAuth2AccessToken> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientCredentials.class);
    private OAuth2AccessToken oAuth2AccessToken;
    private final AccessTokenRetrieverService accessTokenRetrieverService;

    public OAuth2ClientCredentials(AccessTokenRetrieverService accessTokenRetrieverService) {
        Assert.notNull((Object)accessTokenRetrieverService, (String)"accessTokenRetrieverService must not be null");
        this.accessTokenRetrieverService = accessTokenRetrieverService;
    }

    public synchronized void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        if (this.oAuth2AccessToken != null && this.oAuth2AccessToken.getExpiresAt().minus(5L, ChronoUnit.MINUTES).isBefore(Instant.now())) {
            this.oAuth2AccessToken = null;
            this.setAccessToken(null);
            this.refreshOAuth2AccessToken();
        }
        super.applyToParams(queryParams, headerParams, cookieParams);
    }

    public void refreshOAuth2AccessToken() {
        log.debug("Attempting to refresh OAuth2 access token...");
        try {
            this.oAuth2AccessToken = this.accessTokenRetrieverService.getOAuth2AccessToken();
        }
        catch (IOException | InvalidKeyException e) {
            throw new OAuth2TokenRetrieverException("Failed to get OAuth2 access token", e);
        }
        if (this.oAuth2AccessToken == null) {
            throw new OAuth2TokenRetrieverException("Failed to get OAuth2 access token");
        }
    }

    public OAuth2AccessToken getCredentials() {
        return this.oAuth2AccessToken;
    }

    public void setCredentials(OAuth2AccessToken oAuth2AccessToken) {
        this.oAuth2AccessToken = oAuth2AccessToken;
    }

    public String toString() {
        return "<OAuth2ClientCredentials>";
    }
}

