/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.helper.PolicyApiHelper;
import com.okta.sdk.impl.resource.DefaultPolicyBuilder;
import com.okta.sdk.resource.policy.OktaSignOnPolicyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiException;
import org.openapitools.client.api.PolicyApi;
import org.openapitools.client.model.GroupCondition;
import org.openapitools.client.model.OktaSignOnPolicy;
import org.openapitools.client.model.OktaSignOnPolicyConditions;
import org.openapitools.client.model.Policy;
import org.openapitools.client.model.PolicyPeopleCondition;
import org.openapitools.client.model.PolicyType;
import org.openapitools.client.model.UserCondition;

public class DefaultOktaSignOnPolicyBuilder
extends DefaultPolicyBuilder<OktaSignOnPolicyBuilder>
implements OktaSignOnPolicyBuilder {
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();

    public OktaSignOnPolicyBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public OktaSignOnPolicyBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public OktaSignOnPolicy buildAndCreate(PolicyApi client) throws ApiException {
        return (OktaSignOnPolicy)new PolicyApiHelper((PolicyApi)new PolicyApiHelper(client.getApiClient())).createPolicyOfType(OktaSignOnPolicy.class, (Policy)this.build(), this.isActive);
    }

    private OktaSignOnPolicy build() {
        PolicyPeopleCondition policyPeopleCondition;
        OktaSignOnPolicy policy = new OktaSignOnPolicy();
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!PolicyType.OKTA_SIGN_ON.equals((Object)this.policyType)) {
            throw new IllegalArgumentException("PolicyType should be 'OKTA_SIGN_ON', please use PolicyBuilder for other policy types.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        policy.setConditions(new OktaSignOnPolicyConditions());
        OktaSignOnPolicyConditions oktaSignOnPolicyConditions = policy.getConditions();
        if (!Collections.isEmpty(this.groupIds)) {
            GroupCondition groupCondition = new GroupCondition();
            groupCondition.setInclude(this.groupIds);
            policyPeopleCondition = new PolicyPeopleCondition();
            policyPeopleCondition.setGroups(groupCondition);
            oktaSignOnPolicyConditions.setPeople(policyPeopleCondition);
        }
        if (!Collections.isEmpty(this.userIds)) {
            UserCondition userCondition = new UserCondition();
            userCondition.setInclude(this.userIds);
            policyPeopleCondition = new PolicyPeopleCondition();
            policyPeopleCondition.setUsers(userCondition);
            oktaSignOnPolicyConditions.setPeople(policyPeopleCondition);
        }
        return policy;
    }
}

