/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.io;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.io.ClasspathResource;
import com.okta.sdk.impl.io.FileResource;
import com.okta.sdk.impl.io.Resource;
import com.okta.sdk.impl.io.ResourceFactory;
import com.okta.sdk.impl.io.UrlResource;
import java.util.Locale;

public class DefaultResourceFactory
implements ResourceFactory {
    @Override
    public Resource createResource(String location) {
        Assert.hasText((String)location, (String)"location argument cannot be null or empty.");
        if (location.startsWith("classpath:")) {
            return new ClasspathResource(location);
        }
        String lcase = location.toLowerCase(Locale.ENGLISH);
        if (location.startsWith("url:") || lcase.startsWith("http:") || lcase.startsWith("https:")) {
            return new UrlResource(location);
        }
        return new FileResource(location);
    }
}

