/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.policy;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.policy.PolicyType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPolicy
extends AbstractInstanceResource<Policy>
implements Policy {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty descriptionProperty = new StringProperty("description");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final IntegerProperty priorityProperty = new IntegerProperty("priority");
    private static final EnumProperty<Policy.StatusEnum> statusProperty = new EnumProperty<Policy.StatusEnum>("status", Policy.StatusEnum.class);
    private static final BooleanProperty systemProperty = new BooleanProperty("system");
    private static final EnumProperty<PolicyType> typeProperty = new EnumProperty<PolicyType>("type", PolicyType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultPolicy.createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, descriptionProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Policy.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getDescription() {
        return this.getString(descriptionProperty);
    }

    public Policy setDescription(String description) {
        this.setProperty(descriptionProperty, (Object)description);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public Policy setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public Integer getPriority() {
        return this.getIntProperty(priorityProperty);
    }

    public Policy setPriority(Integer priority) {
        this.setProperty(priorityProperty, (Object)priority);
        return this;
    }

    public Policy.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Policy setStatus(Policy.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Boolean getSystem() {
        return this.getBoolean(systemProperty);
    }

    public Policy setSystem(Boolean system) {
        this.setProperty(systemProperty, (Object)system);
        return this;
    }

    public PolicyType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public Policy setType(PolicyType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public void deactivate() {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRule createRule(PolicyRule policyRule, Boolean activate) {
        String policyId = this.getId();
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules", policyRule, this, PolicyRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public PolicyRule createRule(PolicyRule policyRule) {
        String policyId = this.getId();
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules", policyRule, this, PolicyRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public Policy update() {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/policies/" + policyId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    @Override
    public void delete() {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/policies/" + policyId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void activate() {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRuleList listPolicyRules() {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "/rules", PolicyRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRule getPolicyRule(String ruleId) {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "/rules/" + ruleId + "", PolicyRule.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

