/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.resource.user.PasswordCredential;
import com.okta.sdk.resource.user.RecoveryQuestionCredential;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.user.UserProfile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefaultUserBuilder
implements UserBuilder {
    private char[] password;
    private String securityQuestion;
    private String securityQuestionAnswer;
    private String email;
    private String login;
    private String secondEmail;
    private String firstName;
    private String lastName;
    private String mobilePhone;
    private Boolean active;
    private Boolean provider;
    private UserNextLogin nextLogin;
    private Set<String> groupIds = new HashSet<String>();
    private Map<String, Object> customProfileAttributes = new LinkedHashMap<String, Object>();

    public UserBuilder setPassword(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    public UserBuilder setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
        return this;
    }

    public UserBuilder setSecurityQuestionAnswer(String answer) {
        this.securityQuestionAnswer = answer;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public UserBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public UserBuilder setLogin(String login) {
        this.login = login;
        return this;
    }

    public UserBuilder setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public UserBuilder setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
        return this;
    }

    public UserBuilder setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public UserBuilder setProvider(Boolean provider) {
        this.provider = provider;
        return this;
    }

    public UserBuilder setProfileProperties(Map<String, Object> profileProperties) {
        this.customProfileAttributes.clear();
        return this.putAllProfileProperties(profileProperties);
    }

    public UserBuilder putAllProfileProperties(Map<String, Object> profileProperties) {
        this.customProfileAttributes.putAll(profileProperties);
        return this;
    }

    public UserBuilder putProfileProperty(String key, Object value) {
        this.customProfileAttributes.put(key, value);
        return this;
    }

    public UserBuilder setGroups(Set<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public UserBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public UserBuilder setNextLogin(UserNextLogin nextLogin) {
        this.nextLogin = nextLogin;
        return this;
    }

    private User build(Client client) {
        User user = (User)client.instantiate(User.class);
        user.setProfile((UserProfile)client.instantiate(UserProfile.class));
        UserProfile userProfile = user.getProfile();
        if (Strings.hasText((String)this.firstName)) {
            userProfile.setFirstName(this.firstName);
        }
        if (Strings.hasText((String)this.lastName)) {
            userProfile.setLastName(this.lastName);
        }
        if (Strings.hasText((String)this.email)) {
            userProfile.setEmail(this.email);
        }
        if (Strings.hasText((String)this.secondEmail)) {
            userProfile.setSecondEmail(this.secondEmail);
        }
        if (Strings.hasText((String)this.mobilePhone)) {
            userProfile.setMobilePhone(this.mobilePhone);
        }
        if (Strings.hasText((String)this.login)) {
            userProfile.setLogin(this.login);
        } else {
            userProfile.setLogin(this.email);
        }
        if (!Collections.isEmpty(this.groupIds)) {
            if (user instanceof AbstractResource) {
                ((AbstractResource)user).setProperty("groupIds", this.groupIds, true);
            } else {
                throw new IllegalArgumentException("'User' is not an instance of 'AbstractResource', so 'groupIds' cannot be set. This would only happen if the implementation of 'User' has been customized.");
            }
        }
        userProfile.putAll(this.customProfileAttributes);
        if (this.password != null && this.password.length > 0 || Strings.hasText((String)this.securityQuestion)) {
            UserCredentials credentials = (UserCredentials)client.instantiate(UserCredentials.class);
            user.setCredentials(credentials);
            if (Strings.hasText((String)this.securityQuestion)) {
                RecoveryQuestionCredential question = (RecoveryQuestionCredential)client.instantiate(RecoveryQuestionCredential.class);
                question.setQuestion(this.securityQuestion);
                question.setAnswer(this.securityQuestionAnswer);
                credentials.setRecoveryQuestion(question);
            }
            if (this.password != null && this.password.length > 0) {
                PasswordCredential passwordCredential = (PasswordCredential)client.instantiate(PasswordCredential.class);
                credentials.setPassword(passwordCredential.setValue(this.password));
            }
        }
        return user;
    }

    public User buildAndCreate(Client client) {
        return client.createUser(this.build(client), this.active, this.provider, this.nextLogin);
    }
}

