/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.9.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user.factor;

import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorProfile;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Factor
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2019-03-28T17:05:02.708-04:00")
public class DefaultFactor extends AbstractInstanceResource<Factor> implements Factor {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty deviceProperty = new StringProperty("device");
    private final static StringProperty deviceTypeProperty = new StringProperty("deviceType");
    private final static EnumProperty<FactorType> factorTypeProperty = new EnumProperty("factorType", FactorType.class);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty mfaStateTokenIdProperty = new StringProperty("mfaStateTokenId");
    private final static ResourceReference<FactorProfile> profileProperty = new ResourceReference("profile", FactorProfile.class, true);
    private final static EnumProperty<FactorProvider> providerProperty = new EnumProperty("provider", FactorProvider.class);
    private final static BooleanProperty rechallengeExistingFactorProperty = new BooleanProperty("rechallengeExistingFactor");
    private final static StringProperty sessionIdProperty = new StringProperty("sessionId");
    private final static EnumProperty<FactorStatus> statusProperty = new EnumProperty("status", FactorStatus.class);
    private final static IntegerProperty tokenLifetimeSecondsProperty = new IntegerProperty("tokenLifetimeSeconds");
    private final static StringProperty userIdProperty = new StringProperty("userId");
    private final static ResourceReference<VerifyFactorRequest> verifyProperty = new ResourceReference("verify", VerifyFactorRequest.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, deviceProperty, deviceTypeProperty, factorTypeProperty, idProperty, mfaStateTokenIdProperty, profileProperty, providerProperty, rechallengeExistingFactorProperty, sessionIdProperty, statusProperty, tokenLifetimeSecondsProperty, userIdProperty, verifyProperty);

    public DefaultFactor(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultFactor(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Factor.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getDevice() {
        return  getString(deviceProperty);
    }

    public Factor setDevice(String device) {
        setProperty(deviceProperty, device);
        return this;
    }

    public String getDeviceType() {
        return  getString(deviceTypeProperty);
    }

    public FactorType getFactorType() {
        return  getEnumProperty(factorTypeProperty);
    }

    public Factor setFactorType(FactorType factorType) {
        setProperty(factorTypeProperty, factorType);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getMfaStateTokenId() {
        return  getString(mfaStateTokenIdProperty);
    }

    public Factor setMfaStateTokenId(String mfaStateTokenId) {
        setProperty(mfaStateTokenIdProperty, mfaStateTokenId);
        return this;
    }

    public FactorProfile getProfile() {
        return  getResourceProperty(profileProperty);
    }

    public Factor setProfile(FactorProfile profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public FactorProvider getProvider() {
        return  getEnumProperty(providerProperty);
    }

    public Factor setProvider(FactorProvider provider) {
        setProperty(providerProperty, provider);
        return this;
    }

    public Boolean getRechallengeExistingFactor() {
        return  getBoolean(rechallengeExistingFactorProperty);
    }

    public Factor setRechallengeExistingFactor(Boolean rechallengeExistingFactor) {
        setProperty(rechallengeExistingFactorProperty, rechallengeExistingFactor);
        return this;
    }

    public String getSessionId() {
        return  getString(sessionIdProperty);
    }

    public Factor setSessionId(String sessionId) {
        setProperty(sessionIdProperty, sessionId);
        return this;
    }

    public FactorStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Integer getTokenLifetimeSeconds() {
        return  getIntProperty(tokenLifetimeSecondsProperty);
    }

    public Factor setTokenLifetimeSeconds(Integer tokenLifetimeSeconds) {
        setProperty(tokenLifetimeSecondsProperty, tokenLifetimeSeconds);
        return this;
    }

    public String getUserId() {
        return  getString(userIdProperty);
    }

    public Factor setUserId(String userId) {
        setProperty(userIdProperty, userId);
        return this;
    }

    public VerifyFactorRequest getVerify() {
        return  getResourceProperty(verifyProperty);
    }

    public Factor setVerify(VerifyFactorRequest verify) {
        setProperty(verifyProperty, verify);
        return this;
    }


    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    public void delete() {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "";
        getDataStore().delete(href, (Resource) this);
    }




    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; [factor types](#factor-type) require activation to complete the enrollment process.
    * @param body  (required)
    * @return Factor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    public Factor activate(VerifyFactorRequest body) {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate";
        return getDataStore().create(
            href,
            body,
            this,
            Factor.class
        );

    }




    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @param templateId  (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @return VerifyFactorResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    public VerifyFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds) {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (templateId != null) queryArgs.put("templateId", templateId);
        if (tokenLifetimeSeconds != null) queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return getDataStore().create(
            href,
            body,
            this,
            VerifyFactorResponse.class
        );

    }

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @return VerifyFactorResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    public VerifyFactorResponse verify(VerifyFactorRequest body) {

        String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return getDataStore().create(
            href,
            body,
            this,
            VerifyFactorResponse.class
        );

     }

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @param templateId  (required)
    * @return VerifyFactorResponse
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    public VerifyFactorResponse verify(VerifyFactorRequest body, String templateId) {

            String factorId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (body != null) queryArgs.put("body", body);
        if (templateId != null) queryArgs.put("templateId", templateId);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return 
        getDataStore().create(
            href,
            body,
            null,
            VerifyFactorResponse.class
        );

    }

    @Override
    public VerifyFactorResponse verify(String templateId, VerifyFactorRequest body) {
        return verify(body, templateId);
    }

    @Override
    public VerifyFactorResponse verify(String templateId, Integer tokenLifetimeSeconds, VerifyFactorRequest body) {
        return verify(body, templateId, tokenLifetimeSeconds);
    }
}
