/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.9.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.session;

import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.session.SessionAuthenticationMethod;
import com.okta.sdk.resource.session.SessionIdentityProvider;
import com.okta.sdk.resource.session.SessionStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Session
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2019-03-28T17:05:02.708-04:00")
public class DefaultSession extends AbstractInstanceResource<Session> implements Session {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static EnumListProperty<SessionAuthenticationMethod> amrProperty = new EnumListProperty("amr", SessionAuthenticationMethod.class);
    private final static DateProperty createdAtProperty = new DateProperty("createdAt");
    private final static DateProperty expiresAtProperty = new DateProperty("expiresAt");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static ResourceReference<SessionIdentityProvider> idpProperty = new ResourceReference("idp", SessionIdentityProvider.class, false);
    private final static DateProperty lastFactorVerificationProperty = new DateProperty("lastFactorVerification");
    private final static DateProperty lastPasswordVerificationProperty = new DateProperty("lastPasswordVerification");
    private final static StringProperty loginProperty = new StringProperty("login");
    private final static EnumProperty<SessionStatus> statusProperty = new EnumProperty("status", SessionStatus.class);
    private final static StringProperty userIdProperty = new StringProperty("userId");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, amrProperty, createdAtProperty, expiresAtProperty, idProperty, idpProperty, lastFactorVerificationProperty, lastPasswordVerificationProperty, loginProperty, statusProperty, userIdProperty);

    public DefaultSession(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSession(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Session.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public List<SessionAuthenticationMethod> getAmr() {
        return (List<SessionAuthenticationMethod>) getEnumListProperty(amrProperty);
    }

    public Date getCreatedAt() {
        return  getDateProperty(createdAtProperty);
    }

    public Date getExpiresAt() {
        return  getDateProperty(expiresAtProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public SessionIdentityProvider getIdp() {
        return  getResourceProperty(idpProperty);
    }

    public Date getLastFactorVerification() {
        return  getDateProperty(lastFactorVerificationProperty);
    }

    public Date getLastPasswordVerification() {
        return  getDateProperty(lastPasswordVerificationProperty);
    }

    public String getLogin() {
        return  getString(loginProperty);
    }

    public SessionStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public String getUserId() {
        return  getString(userIdProperty);
    }


    /**
    * Refresh Session
    * 
    * @return Session
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "POST - /api/v1/sessions/{sessionId}/lifecycle/refresh")
    public Session refresh() {

        String sessionId = getId();

        hasText(sessionId, "'sessionId' is required and cannot be null or empty.");

        String href = "/api/v1/sessions/" + sessionId + "/lifecycle/refresh";
        return getDataStore().create(
            href,
            new DefaultVoidResource(getDataStore()),
            this,
            Session.class
        );

    }




    /**
    * Close Session
    * 
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2019-03-28T17:05:02.708-04:00",
          comments = "DELETE - /api/v1/sessions/{sessionId}")
    public void delete() {

        String sessionId = getId();

        hasText(sessionId, "'sessionId' is required and cannot be null or empty.");

        String href = "/api/v1/sessions/" + sessionId + "";
        getDataStore().delete(href, (Resource) this);
    }



}
