/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.9.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.okta.sdk.impl.client;

import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.config.ClientConfiguration;

import com.okta.sdk.client.*;

import com.okta.sdk.resource.user.AppLink;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.log.LogEvent;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.factor.SecurityQuestion;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.user.AuthenticationProviderType;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.DefaultVoidResource;

import java.util.LinkedHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2019-03-28T17:05:02.708-04:00")
@SuppressWarnings("deprecation")
public class DefaultClient extends com.okta.sdk.impl.client.AbstractClient {

    /**
    * Instantiates a new Client instance that will communicate with the Okta REST API.  See the class-level
    * JavaDoc for a usage example.
    *
    * @param clientCredentialsResolver   Okta API Key resolver
    * @param baseUrlResolver             Okta base URL resolver
    * @param proxy                       the HTTP proxy to be used when communicating with the Okta API server (can be
    *                                    null)
    * @param cacheManager                the {@link CacheManager} that should be used to cache
    *                                    Okta REST resources (can be null)
    * @param authenticationScheme        the HTTP authentication scheme to be used when communicating with the Okta API
    * @param requestAuthenticatorFactory
    * @param connectionTimeout
    */
    @Deprecated
    public DefaultClient(ClientCredentialsResolver clientCredentialsResolver,
                         BaseUrlResolver baseUrlResolver,
                         Proxy proxy,
                         CacheManager cacheManager,
                         AuthenticationScheme authenticationScheme,
                         RequestAuthenticatorFactory requestAuthenticatorFactory,
                         int connectionTimeout) {
        super(clientCredentialsResolver, baseUrlResolver, proxy, cacheManager, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
    }

    /**
    * Instantiates a new Client instance that will communicate with the Okta REST API.  See the class-level
    * JavaDoc for a usage example.
    *
    * @param clientConfiguration  the {@link ClientConfiguration} containing the connection information
    * @param cacheManager         the {@link CacheManager} that should be used to cache
    */
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }


    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @param q  (optional)
    * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
    * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
    * @param includeNonDeleted  (optional, default to false)
    * @return ApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/apps")
    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {

        QueryString queryArgs = new QueryString();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (expand != null) queryArgs.put("expand", expand);
        if (includeNonDeleted != null) queryArgs.put("includeNonDeleted", includeNonDeleted);

        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        return getDataStore().getResource(href, ApplicationList.class);
    }

    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @return ApplicationList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/apps")
    public ApplicationList listApplications() {

        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        return getDataStore().getResource(href, ApplicationList.class);
    }


    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/apps")
    public Application createApplication(Application application, Boolean activate) {

        notNull(application, "'application' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) queryArgs.put("activate", activate);

        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        
        getDataStore().create(
            href,
            application,
            null,
            Application.class
        );
        return application;

    }

    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/apps")
    public Application createApplication(Application application) {

        notNull(application, "'application' is required and cannot be null.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        
        getDataStore().create(
            href,
            application,
            null,
            Application.class
        );
        return application;

    }


    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @param expand  (optional)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/apps/{appId}")
    public Application getApplication(String appId, String expand) {

        hasText(appId, "'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "", queryArgs);
        return getDataStore().getResource(href, Application.class);
    }

    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/apps/{appId}")
    public Application getApplication(String appId) {

        hasText(appId, "'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/apps/" + appId + "", queryArgs);
        return getDataStore().getResource(href, Application.class);
    }


    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @param q Searches the name property of groups for matching value (optional)
    * @param filter Filter expression for groups (optional)
    * @param expand  (optional)
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups")
    public GroupList listGroups(String q, String filter, String expand) {

        QueryString queryArgs = new QueryString();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return getDataStore().getResource(href, GroupList.class);
    }

    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups")
    public GroupList listGroups() {

        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return getDataStore().getResource(href, GroupList.class);
    }


    /**
    * Add Group
    * Adds a new group with &#x60;OKTA_GROUP&#x60; type to your organization.
    * @param group  (required)
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/groups")
    public Group createGroup(Group group) {

        notNull(group, "'group' is required and cannot be null.");

        String href = "/api/v1/groups";
        
        getDataStore().create(
            href,
            group,
            null,
            Group.class
        );
        return group;

    }



    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param expand  (optional, default to )
    * @return GroupRuleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/rules")
    public GroupRuleList listRules(String expand) {

        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/groups/rules", queryArgs);
        return getDataStore().getResource(href, GroupRuleList.class);
    }

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @return GroupRuleList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/rules")
    public GroupRuleList listRules() {

        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/groups/rules", queryArgs);
        return getDataStore().getResource(href, GroupRuleList.class);
    }


    /**
    * Create Group Rule
    * Creates a group rule to dynamically add users to the specified group if they match the condition
    * @param groupRule  (required)
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/groups/rules")
    public GroupRule createRule(GroupRule groupRule) {

        notNull(groupRule, "'groupRule' is required and cannot be null.");

        String href = "/api/v1/groups/rules";
        
        getDataStore().create(
            href,
            groupRule,
            null,
            GroupRule.class
        );
        return groupRule;

    }



    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @param expand  (optional, default to )
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    public GroupRule getRule(String ruleId, String expand) {

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        return getDataStore().getResource(href, GroupRule.class);
    }

    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    public GroupRule getRule(String ruleId) {

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        return getDataStore().getResource(href, GroupRule.class);
    }


    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param groupId  (required)
    * @param expand  (optional)
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/{groupId}")
    public Group getGroup(String groupId, String expand) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return getDataStore().getResource(href, Group.class);
    }

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param groupId  (required)
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/groups/{groupId}")
    public Group getGroup(String groupId) {

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return getDataStore().getResource(href, Group.class);
    }


    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @param until  (optional)
    * @param since  (optional)
    * @param filter  (optional)
    * @param q  (optional)
    * @param sortOrder  (optional, default to ASCENDING)
    * @return LogEventList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/logs")
    public LogEventList getLogs(String until, String since, String filter, String q, String sortOrder) {

        QueryString queryArgs = new QueryString();
        if (until != null) queryArgs.put("until", until);
        if (since != null) queryArgs.put("since", since);
        if (filter != null) queryArgs.put("filter", filter);
        if (q != null) queryArgs.put("q", q);
        if (sortOrder != null) queryArgs.put("sortOrder", sortOrder);

        String href = QueryString.buildHref("/api/v1/logs", queryArgs);
        return getDataStore().getResource(href, LogEventList.class);
    }

    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @return LogEventList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/logs")
    public LogEventList getLogs() {

        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/logs", queryArgs);
        return getDataStore().getResource(href, LogEventList.class);
    }


    /**
    * 
    * 
    * @param type  (required)
    * @param status  (optional)
    * @param expand  (optional, default to )
    * @return PolicyList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/policies")
    public PolicyList listPolicies(String type, String status, String expand) {

        notNull(type, "'type' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (type != null) queryArgs.put("type", type);
        if (status != null) queryArgs.put("status", status);
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        return getDataStore().getResource(href, PolicyList.class);
    }

    /**
    * 
    * 
    * @param type  (required)
    * @return PolicyList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/policies")
    public PolicyList listPolicies(String type) {

        notNull(type, "'type' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        queryArgs.put("type", type);

        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        return getDataStore().getResource(href, PolicyList.class);
    }


    /**
    * 
    * 
    * @param policy  (required)
    * @param activate  (optional, default to true)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/policies")
    public Policy createPolicy(Policy policy, Boolean activate) {

        notNull(policy, "'policy' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) queryArgs.put("activate", activate);

        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        
        getDataStore().create(
            href,
            policy,
            null,
            Policy.class
        );
        return policy;

    }

    /**
    * 
    * 
    * @param policy  (required)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/policies")
    public Policy createPolicy(Policy policy) {

        notNull(policy, "'policy' is required and cannot be null.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        
        getDataStore().create(
            href,
            policy,
            null,
            Policy.class
        );
        return policy;

    }


    /**
    * 
    * 
    * @param policyId  (required)
    * @param expand  (optional, default to )
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/policies/{policyId}")
    public Policy getPolicy(String policyId, String expand) {

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/policies/" + policyId + "", queryArgs);
        return getDataStore().getResource(href, Policy.class);
    }

    /**
    * 
    * 
    * @param policyId  (required)
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/policies/{policyId}")
    public Policy getPolicy(String policyId) {

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/policies/" + policyId + "", queryArgs);
        return getDataStore().getResource(href, Policy.class);
    }


    /**
    * Create Session with Session Token
    * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
    * @param createSessionRequest  (required)
    * @return Session
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/sessions")
    public Session createSession(CreateSessionRequest createSessionRequest) {

        notNull(createSessionRequest, "'createSessionRequest' is required and cannot be null.");

        String href = "/api/v1/sessions";
        return 
        getDataStore().create(
            href,
            createSessionRequest,
            null,
            Session.class
        );

    }



    /**
    * 
    * Get details about a session.
    * @param sessionId  (required)
    * @return Session
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/sessions/{sessionId}")
    public Session getSession(String sessionId) {

        hasText(sessionId, "'sessionId' is required and cannot be null or empty.");

        String href = "/api/v1/sessions/" + sessionId + "";
        return getDataStore().getResource(href, Session.class);
    }



    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @param q Finds a user that matches firstName, lastName, and email properties (optional)
    * @param filter Filters users with a supported expression for a subset of properties (optional)
    * @param format  (optional)
    * @param search Searches for users with a supported filtering  expression for most properties (optional)
    * @param expand  (optional)
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/users")
    public UserList listUsers(String q, String filter, String format, String search, String expand) {

        QueryString queryArgs = new QueryString();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (format != null) queryArgs.put("format", format);
        if (search != null) queryArgs.put("search", search);
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return getDataStore().getResource(href, UserList.class);
    }

    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/users")
    public UserList listUsers() {

        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return getDataStore().getResource(href, UserList.class);
    }


    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
    * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
    * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional, default to )
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/users")
    public User createUser(User body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {

        notNull(body, "'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) queryArgs.put("activate", activate);
        if (provider != null) queryArgs.put("provider", provider);
        if (nextLogin != null) queryArgs.put("nextLogin", nextLogin);

        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        
        getDataStore().create(
            href,
            body,
            null,
            User.class
        );
        return body;

    }

    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/users")
    public User createUser(User body) {

        notNull(body, "'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();


        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        
        getDataStore().create(
            href,
            body,
            null,
            User.class
        );
        return body;

    }

    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @param activate Executes activation lifecycle operation when creating the user (required)
    * @param provider Indicates whether to create a user with a specified authentication provider (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "POST - /api/v1/users")
    public User createUser(User body, Boolean activate, Boolean provider) {

        notNull(body, "'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (body != null) queryArgs.put("body", body);
        if (activate != null) queryArgs.put("activate", activate);
        if (provider != null) queryArgs.put("provider", provider);

        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        
        getDataStore().create(
            href,
            body,
            null,
            User.class
        );
        return body;

    }

    /**
    * Get User
    * Fetches a user from your Okta organization.
    * @param userId  (required)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
            date     = "2019-03-28T17:05:02.708-04:00",
            comments = "GET - /api/v1/users/{userId}")
    public User getUser(String userId) {

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "";
        return getDataStore().getResource(href, User.class);
    }


}
