/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.authc;

import com.okta.commons.lang.Classes;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.impl.http.authc.RequestAuthenticator;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.http.authc.SswsAuthenticator;
import com.okta.sdk.impl.http.support.RequestAuthenticationException;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestAuthenticatorFactory
implements RequestAuthenticatorFactory {
    private final Logger log = LoggerFactory.getLogger(DefaultRequestAuthenticatorFactory.class);

    @Override
    public RequestAuthenticator create(AuthenticationScheme scheme, ClientCredentials clientCredentials) {
        if (scheme == null) {
            return new SswsAuthenticator(clientCredentials);
        }
        try {
            Class requestAuthenticatorClass = Classes.forName((String)scheme.getRequestAuthenticatorClassName());
            Constructor ctor = Classes.getConstructor((Class)requestAuthenticatorClass, (Class[])new Class[]{ClientCredentials.class});
            return (RequestAuthenticator)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{clientCredentials});
        }
        catch (RuntimeException ex) {
            String errormessage = "There was an error instantiating " + scheme.getRequestAuthenticatorClassName();
            this.log.error(errormessage, (Throwable)ex);
            throw new RequestAuthenticationException(errormessage);
        }
    }
}

