/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.ds.DataStore;
import com.okta.sdk.ds.RequestBuilder;
import com.okta.sdk.error.Error;
import com.okta.sdk.http.HttpMethod;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.cache.DisabledCacheManager;
import com.okta.sdk.impl.ds.DefaultCacheRegionNameResolver;
import com.okta.sdk.impl.ds.DefaultFilterChain;
import com.okta.sdk.impl.ds.DefaultRequestBuilder;
import com.okta.sdk.impl.ds.DefaultResourceConverter;
import com.okta.sdk.impl.ds.DefaultResourceDataRequest;
import com.okta.sdk.impl.ds.DefaultResourceDataResult;
import com.okta.sdk.impl.ds.DefaultResourceFactory;
import com.okta.sdk.impl.ds.Filter;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.ds.JacksonMapMarshaller;
import com.okta.sdk.impl.ds.MapMarshaller;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceConverter;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.ds.ResourceFactory;
import com.okta.sdk.impl.ds.cache.DefaultCacheResolver;
import com.okta.sdk.impl.ds.cache.DefaultResourceCacheStrategy;
import com.okta.sdk.impl.ds.cache.ReadCacheFilter;
import com.okta.sdk.impl.ds.cache.WriteCacheFilter;
import com.okta.sdk.impl.error.DefaultError;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.HttpHeadersHolder;
import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.Request;
import com.okta.sdk.impl.http.RequestExecutor;
import com.okta.sdk.impl.http.Response;
import com.okta.sdk.impl.http.support.DefaultCanonicalUri;
import com.okta.sdk.impl.http.support.DefaultRequest;
import com.okta.sdk.impl.http.support.UserAgent;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.HalResourceHrefResolver;
import com.okta.sdk.impl.resource.ReferenceFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.impl.util.DefaultBaseUrlResolver;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.ResourceException;
import com.okta.sdk.resource.VoidResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStore
implements InternalDataStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStore.class);
    private static final Logger requestLog = LoggerFactory.getLogger((String)(DataStore.class.getName() + "-request"));
    private static final String HREF_REQD_MSG = "'save' may only be called on objects that have already been persisted and have an existing 'href' attribute.";
    private final RequestExecutor requestExecutor;
    private final ResourceFactory resourceFactory;
    private final MapMarshaller mapMarshaller;
    private final CacheManager cacheManager;
    private final ResourceConverter resourceConverter;
    private final List<Filter> filters;
    private final ClientCredentialsResolver clientCredentialsResolver;
    private final BaseUrlResolver baseUrlResolver;
    private static final String USER_AGENT_STRING = UserAgent.getUserAgentString();

    public DefaultDataStore(RequestExecutor requestExecutor, String baseUrl, ClientCredentialsResolver clientCredentialsResolver) {
        this(requestExecutor, new DefaultBaseUrlResolver(baseUrl), clientCredentialsResolver, new DisabledCacheManager());
    }

    public DefaultDataStore(RequestExecutor requestExecutor, BaseUrlResolver baseUrlResolver, ClientCredentialsResolver clientCredentialsResolver, CacheManager cacheManager) {
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver cannot be null");
        Assert.notNull((Object)requestExecutor, (String)"RequestExecutor cannot be null.");
        Assert.notNull((Object)clientCredentialsResolver, (String)"clientCredentialsResolver cannot be null.");
        Assert.notNull((Object)cacheManager, (String)"CacheManager cannot be null.  Use the DisabledCacheManager if you wish to turn off caching.");
        this.requestExecutor = requestExecutor;
        this.baseUrlResolver = baseUrlResolver;
        this.cacheManager = cacheManager;
        this.resourceFactory = new DefaultResourceFactory(this);
        this.mapMarshaller = new JacksonMapMarshaller();
        DefaultCacheResolver cacheResolver = new DefaultCacheResolver(this.cacheManager, new DefaultCacheRegionNameResolver());
        this.clientCredentialsResolver = clientCredentialsResolver;
        ReferenceFactory referenceFactory = new ReferenceFactory();
        this.resourceConverter = new DefaultResourceConverter(referenceFactory);
        this.filters = new ArrayList<Filter>();
        if (this.isCachingEnabled()) {
            DefaultResourceCacheStrategy cacheStrategy = new DefaultResourceCacheStrategy(new HalResourceHrefResolver(), cacheResolver);
            this.filters.add(new ReadCacheFilter(cacheStrategy));
            this.filters.add(new WriteCacheFilter(cacheStrategy));
        }
    }

    public ClientCredentials getClientCredentials() {
        return this.clientCredentialsResolver.getClientCredentials();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return this.resourceFactory.instantiate(clazz, new Object[0]);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties) {
        return this.resourceFactory.instantiate(clazz, properties);
    }

    private <T extends Resource> T instantiate(Class<T> clazz, Map<String, ?> properties, QueryString qs) {
        if (CollectionResource.class.isAssignableFrom(clazz)) {
            return this.resourceFactory.instantiate(clazz, properties, qs);
        }
        return this.resourceFactory.instantiate(clazz, properties);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return this.getResource(href, clazz, null);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Map<String, Object> queryParameters) {
        ResourceDataResult result = this.getResourceData(href, clazz, queryParameters);
        T resource = this.instantiate(clazz, result.getData(), result.getUri().getQuery());
        resource.setResourceHref(href);
        return resource;
    }

    private ResourceDataResult getResourceData(String href, Class<? extends Resource> clazz, Map<String, ?> queryParameters) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, req -> {
            CanonicalUri uri = req.getUri();
            DefaultRequest getRequest = new DefaultRequest(HttpMethod.GET, uri.getAbsolutePath(), uri.getQuery());
            Response getResponse = this.execute(getRequest);
            Map<String, Object> body = this.getBody(getResponse);
            if (Collections.isEmpty(body)) {
                throw new IllegalStateException("Unable to obtain resource data from the API server or from cache.");
            }
            return new DefaultResourceDataResult(req.getAction(), uri, req.getResourceClass(), body);
        });
        CanonicalUri uri = this.canonicalize(href, queryParameters);
        DefaultResourceDataRequest req2 = new DefaultResourceDataRequest(ResourceAction.READ, uri, clazz, new HashMap<String, Object>());
        return chain.filter(req2);
    }

    private ResourceAction getPostAction(ResourceDataRequest request, Response response) {
        int httpStatus = response.getHttpStatus();
        if (httpStatus == 201) {
            return ResourceAction.CREATE;
        }
        if (httpStatus == 200) {
            return ResourceAction.READ;
        }
        return request.getAction();
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource, T parentResource) {
        return (T)this.create(parentHref, resource, parentResource, resource.getClass());
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, T parentResource, Class<? extends R> returnType) {
        return this.create(parentHref, resource, parentResource, returnType, null);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, T parentResource, Class<? extends R> returnType, Map<String, Object> queryParameters) {
        return this.save(parentHref, resource, parentResource, null, returnType, new QueryString(queryParameters), true);
    }

    @Override
    public <T extends Resource> void save(T resource) {
        this.save(resource.getResourceHref(), resource);
    }

    @Override
    public <T extends Resource> void save(String href, T resource, T parentResource) {
        this.save(href, resource, parentResource, null);
    }

    @Override
    public <T extends Resource> void save(String href, T resource, T parentResource, Map<String, Object> queryParameters) {
        Assert.hasText((String)href, (String)HREF_REQD_MSG);
        this.save(href, resource, parentResource, null, this.getResourceClass(resource), new QueryString(queryParameters), false);
    }

    private <T extends Resource, R extends Resource> R save(String href, T resource, T parentResource, HttpHeaders requestHeaders, Class<? extends R> returnType, QueryString qs, boolean create) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.notNull(returnType, (String)"returnType class cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.isTrue((!CollectionResource.class.isAssignableFrom(resource.getClass()) ? 1 : 0) != 0, (String)"Collections cannot be persisted.");
        CanonicalUri uri = this.canonicalize(href, qs);
        AbstractResource abstractResource = (AbstractResource)resource;
        Map<String, Object> props = this.resourceConverter.convert(abstractResource, false);
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, req -> {
            ByteArrayInputStream body;
            CanonicalUri uri1 = req.getUri();
            String href1 = uri1.getAbsolutePath();
            QueryString qs1 = uri1.getQuery();
            HttpHeaders httpHeaders = req.getHttpHeaders();
            HttpMethod method = HttpMethod.POST;
            if (!create) {
                method = HttpMethod.PUT;
            }
            long length = 0L;
            if (resource instanceof VoidResource) {
                body = new ByteArrayInputStream(new byte[0]);
            } else {
                ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
                this.mapMarshaller.marshal(bodyOut, req.getData());
                body = new ByteArrayInputStream(bodyOut.toByteArray());
                length = bodyOut.size();
            }
            DefaultRequest request = new DefaultRequest(method, href1, qs1, httpHeaders, body, length);
            Response response = this.execute(request);
            Map<String, Object> responseBody = this.getBody(response);
            if (Collections.isEmpty(responseBody)) {
                if (response.getHttpStatus() == 202 || response.getHttpStatus() == 200 || response.getHttpStatus() == 204) {
                    responseBody = java.util.Collections.emptyMap();
                } else {
                    throw new IllegalStateException("Unable to obtain resource data from the API server.");
                }
            }
            ResourceAction responseAction = this.getPostAction(req, response);
            return new DefaultResourceDataResult(responseAction, uri1, returnType, responseBody);
        });
        ResourceAction action = create ? ResourceAction.CREATE : ResourceAction.UPDATE;
        DefaultResourceDataRequest request = new DefaultResourceDataRequest(action, uri, this.canonicalizeParent(parentResource), returnType, this.getResourceClass(parentResource), props, requestHeaders);
        ResourceDataResult result = chain.filter(request);
        Map<String, Object> data = result.getData();
        if (returnType.isAssignableFrom(abstractResource.getClass())) {
            abstractResource.setInternalProperties(data);
        }
        return this.resourceFactory.instantiate(returnType, data);
    }

    @Override
    public void delete(String href) {
        this.delete(href, (Resource)null);
    }

    @Override
    public void delete(String href, Map<String, Object> queryParameters) {
        this.doDelete(href, VoidResource.class, new QueryString(queryParameters));
    }

    @Override
    public <T extends Resource> void delete(T resource) {
        this.doDelete(resource.getResourceHref(), resource);
    }

    @Override
    public <T extends Resource> void delete(String href, T resource) {
        this.doDelete(href, resource);
    }

    private void doDelete(String resourceHref, Class resourceClass, QueryString qs) {
        Assert.hasText((String)resourceHref, (String)"This resource does not have an href value, therefore it cannot be deleted.");
        CanonicalUri uri = this.canonicalize(resourceHref, qs);
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, request -> {
            DefaultRequest deleteRequest = new DefaultRequest(HttpMethod.DELETE, uri.getAbsolutePath(), uri.getQuery());
            this.execute(deleteRequest);
            return new DefaultResourceDataResult(request.getAction(), request.getUri(), request.getResourceClass(), new HashMap<String, Object>());
        });
        CanonicalUri resourceUri = this.canonicalize(resourceHref, null);
        DefaultResourceDataRequest request2 = new DefaultResourceDataRequest(ResourceAction.DELETE, resourceUri, resourceClass, new HashMap<String, Object>());
        chain.filter(request2);
    }

    private <T extends Resource> void doDelete(String href, T resource) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource, (String)"Resource argument must be an AbstractResource.");
        this.doDelete(href != null ? href : resource.getResourceHref(), this.getResourceClass(resource), null);
    }

    protected boolean isCachingEnabled() {
        return this.cacheManager != null && !(this.cacheManager instanceof DisabledCacheManager);
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrlResolver.getBaseUrl();
    }

    private Response execute(Request request) throws ResourceException {
        this.applyDefaultRequestHeaders(request);
        Response response = this.requestExecutor.executeRequest(request);
        log.trace("Executed HTTP request.");
        if (requestLog.isTraceEnabled()) {
            requestLog.trace("Executing request: method: '{}', url: {}", (Object)request.getMethod(), (Object)request.getResourceUrl());
        }
        if (response.isError()) {
            Map<String, Object> body = this.getBody(response);
            String requestId = response.getHeaders().getOktaRequestId();
            if (Strings.hasText((String)requestId)) {
                body.put(DefaultError.ERROR_ID.getName(), requestId);
            }
            throw new ResourceException((Error)new DefaultError(body).setHeaders(response.getHeaders().getXHeaders()).setStatus(response.getHttpStatus()));
        }
        return response;
    }

    private Map<String, Object> getBody(Response response) {
        Assert.notNull((Object)response, (String)"response argument cannot be null.");
        Map<String, Object> out = null;
        if (response.hasBody()) {
            out = this.mapMarshaller.unmarshal(response.getBody(), response.getHeaders().getLinkMap());
        }
        return out;
    }

    protected void applyDefaultRequestHeaders(Request request) {
        List<String> clientRequestId;
        request.getHeaders().setAccept(java.util.Collections.singletonList(MediaType.APPLICATION_JSON));
        Map<String, List<String>> headerMap = HttpHeadersHolder.get();
        String oktaAgentHeaderName = "X-Okta-Agent".toLowerCase(Locale.ENGLISH);
        if (headerMap != null && headerMap.get(oktaAgentHeaderName) != null) {
            List<String> oktaAgents = headerMap.get(oktaAgentHeaderName);
            if (oktaAgents != null && !oktaAgents.isEmpty()) {
                String oktaAgent = Strings.arrayToDelimitedString((Object[])oktaAgents.toArray(), (String)" ");
                request.getHeaders().set("User-Agent", oktaAgent + " " + USER_AGENT_STRING);
            }
        } else {
            request.getHeaders().set("User-Agent", USER_AGENT_STRING);
        }
        if (request.getHeaders().getContentType() == null && request.getBody() != null) {
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        }
        if (headerMap != null && (clientRequestId = headerMap.get("X-Okta-Client-Request-Id")) != null) {
            request.getHeaders().put("X-Okta-Client-Request-Id", clientRequestId);
        }
    }

    private CanonicalUri canonicalize(String href, Map<String, ?> queryParams) {
        href = this.ensureFullyQualified(href);
        return DefaultCanonicalUri.create(href, queryParams);
    }

    private CanonicalUri canonicalizeParent(Resource parentResource) {
        if (parentResource != null && parentResource.getResourceHref() != null) {
            String href = this.ensureFullyQualified(parentResource.getResourceHref());
            return DefaultCanonicalUri.create(href, null);
        }
        return null;
    }

    private String ensureFullyQualified(String href) {
        String value = href;
        if (!this.isFullyQualified(href)) {
            value = this.qualify(href);
        }
        return value;
    }

    private boolean isFullyQualified(String href) {
        if (href == null || href.length() < 5) {
            return false;
        }
        return href.regionMatches(true, 0, "http", 0, 4);
    }

    private String qualify(String href) {
        StringBuilder sb = new StringBuilder(this.baseUrlResolver.getBaseUrl());
        if (!href.startsWith("/")) {
            sb.append("/");
        }
        sb.append(href);
        return sb.toString();
    }

    private Class<? extends Resource> getResourceClass(Resource resource) {
        if (AbstractInstanceResource.class.isInstance(resource)) {
            return ((AbstractInstanceResource)resource).getResourceClass();
        }
        return resource != null ? resource.getClass() : null;
    }

    public RequestBuilder http() {
        return new DefaultRequestBuilder(this);
    }
}

