/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.config.EnvVarNameConverter;

public class DefaultEnvVarNameConverter
implements EnvVarNameConverter {
    @Override
    public String toEnvVarName(String dottedPropertyName) {
        Assert.hasText((String)dottedPropertyName, (String)"dottedPropertyName argument cannot be null or empty.");
        dottedPropertyName = Strings.trimWhitespace((String)dottedPropertyName);
        StringBuilder sb = new StringBuilder();
        for (char c : dottedPropertyName.toCharArray()) {
            if (c == '.') {
                sb.append('_');
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    @Override
    public String toDottedPropertyName(String envVarName) {
        Assert.hasText((String)envVarName, (String)"envVarName argument cannot be null or empty.");
        envVarName = Strings.trimWhitespace((String)envVarName);
        if ("OKTA_CLIENT_TOKEN".equals(envVarName)) {
            return "okta.client.token";
        }
        if ("OKTA_CLIENT_AUTHENTICATIONSCHEME".equals(envVarName)) {
            return "okta.client.authenticationScheme";
        }
        if ("OKTA_CLIENT_ORGURL".equals(envVarName)) {
            return "okta.client.orgUrl";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : envVarName.toCharArray()) {
            if (c == '_') {
                sb.append('.');
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

