/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.lang.Assert;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.client.AbstractClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.UserNextLogin;

public class DefaultClient
extends AbstractClient {
    @Deprecated
    public DefaultClient(ClientCredentialsResolver clientCredentialsResolver, BaseUrlResolver baseUrlResolver, Proxy proxy, CacheManager cacheManager, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        super(clientCredentialsResolver, baseUrlResolver, proxy, cacheManager, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
    }

    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }

    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        if (includeNonDeleted != null) {
            queryArgs.put("includeNonDeleted", includeNonDeleted);
        }
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        return (ApplicationList)this.getDataStore().getResource(href, ApplicationList.class);
    }

    public ApplicationList listApplications() {
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        return (ApplicationList)this.getDataStore().getResource(href, ApplicationList.class);
    }

    public Application createApplication(Application application, Boolean activate) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        this.getDataStore().create(href, application, null, Application.class);
        return application;
    }

    public Application createApplication(Application application) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        this.getDataStore().create(href, application, null, Application.class);
        return application;
    }

    public Application getApplication(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "", queryArgs);
        return (Application)this.getDataStore().getResource(href, Application.class);
    }

    public Application getApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "", queryArgs);
        return (Application)this.getDataStore().getResource(href, Application.class);
    }

    public GroupList listGroups(String q, String filter, String expand) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public GroupList listGroups() {
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"'group' is required and cannot be null.");
        String href = "/api/v1/groups";
        this.getDataStore().create(href, group, null, Group.class);
        return group;
    }

    public GroupRuleList listRules(String expand) {
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups/rules", queryArgs);
        return (GroupRuleList)this.getDataStore().getResource(href, GroupRuleList.class);
    }

    public GroupRuleList listRules() {
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/groups/rules", queryArgs);
        return (GroupRuleList)this.getDataStore().getResource(href, GroupRuleList.class);
    }

    public GroupRule createRule(GroupRule groupRule) {
        Assert.notNull((Object)groupRule, (String)"'groupRule' is required and cannot be null.");
        String href = "/api/v1/groups/rules";
        this.getDataStore().create(href, groupRule, null, GroupRule.class);
        return groupRule;
    }

    public GroupRule getRule(String ruleId, String expand) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        return (GroupRule)this.getDataStore().getResource(href, GroupRule.class);
    }

    public GroupRule getRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        return (GroupRule)this.getDataStore().getResource(href, GroupRule.class);
    }

    public Group getGroup(String groupId, String expand) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public Group getGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public LogEventList getLogs(String until, String since, String filter, String q, String sortOrder) {
        QueryString queryArgs = new QueryString();
        if (until != null) {
            queryArgs.put("until", until);
        }
        if (since != null) {
            queryArgs.put("since", since);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        String href = QueryString.buildHref("/api/v1/logs", queryArgs);
        return (LogEventList)this.getDataStore().getResource(href, LogEventList.class);
    }

    public LogEventList getLogs() {
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/logs", queryArgs);
        return (LogEventList)this.getDataStore().getResource(href, LogEventList.class);
    }

    public PolicyList listPolicies(String type, String status, String expand) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (type != null) {
            queryArgs.put("type", type);
        }
        if (status != null) {
            queryArgs.put("status", status);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        return (PolicyList)this.getDataStore().getResource(href, PolicyList.class);
    }

    public PolicyList listPolicies(String type) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        queryArgs.put("type", type);
        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        return (PolicyList)this.getDataStore().getResource(href, PolicyList.class);
    }

    public Policy createPolicy(Policy policy, Boolean activate) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        this.getDataStore().create(href, policy, null, Policy.class);
        return policy;
    }

    public Policy createPolicy(Policy policy) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/policies", queryArgs);
        this.getDataStore().create(href, policy, null, Policy.class);
        return policy;
    }

    public Policy getPolicy(String policyId, String expand) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/policies/" + policyId + "", queryArgs);
        return (Policy)this.getDataStore().getResource(href, Policy.class);
    }

    public Policy getPolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/policies/" + policyId + "", queryArgs);
        return (Policy)this.getDataStore().getResource(href, Policy.class);
    }

    public Session createSession(CreateSessionRequest createSessionRequest) {
        Assert.notNull((Object)createSessionRequest, (String)"'createSessionRequest' is required and cannot be null.");
        String href = "/api/v1/sessions";
        return this.getDataStore().create(href, createSessionRequest, null, Session.class);
    }

    public Session getSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        String href = "/api/v1/sessions/" + sessionId + "";
        return (Session)this.getDataStore().getResource(href, Session.class);
    }

    public UserList listUsers(String q, String filter, String format, String search, String expand) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (format != null) {
            queryArgs.put("format", format);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }

    public UserList listUsers() {
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }

    public User createUser(User body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (nextLogin != null) {
            queryArgs.put("nextLogin", nextLogin);
        }
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        this.getDataStore().create(href, body, null, User.class);
        return body;
    }

    public User createUser(User body) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        this.getDataStore().create(href, body, null, User.class);
        return body;
    }

    public User createUser(User body, Boolean activate, Boolean provider) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        QueryString queryArgs = new QueryString();
        if (body != null) {
            queryArgs.put("body", body);
        }
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        this.getDataStore().create(href, body, null, User.class);
        return body;
    }

    public User getUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "";
        return (User)this.getDataStore().getResource(href, User.class);
    }
}

