/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.session;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.session.SessionAuthenticationMethod;
import com.okta.sdk.resource.session.SessionIdentityProvider;
import com.okta.sdk.resource.session.SessionStatus;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DefaultSession
extends AbstractInstanceResource<Session>
implements Session {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final EnumListProperty<SessionAuthenticationMethod> amrProperty = new EnumListProperty<SessionAuthenticationMethod>("amr", SessionAuthenticationMethod.class);
    private static final DateProperty createdAtProperty = new DateProperty("createdAt");
    private static final DateProperty expiresAtProperty = new DateProperty("expiresAt");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final ResourceReference<SessionIdentityProvider> idpProperty = new ResourceReference<SessionIdentityProvider>("idp", SessionIdentityProvider.class, false);
    private static final DateProperty lastFactorVerificationProperty = new DateProperty("lastFactorVerification");
    private static final DateProperty lastPasswordVerificationProperty = new DateProperty("lastPasswordVerification");
    private static final StringProperty loginProperty = new StringProperty("login");
    private static final EnumProperty<SessionStatus> statusProperty = new EnumProperty<SessionStatus>("status", SessionStatus.class);
    private static final StringProperty userIdProperty = new StringProperty("userId");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultSession.createPropertyDescriptorMap(linksProperty, amrProperty, createdAtProperty, expiresAtProperty, idProperty, idpProperty, lastFactorVerificationProperty, lastPasswordVerificationProperty, loginProperty, statusProperty, userIdProperty);

    public DefaultSession(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSession(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Session.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public List<SessionAuthenticationMethod> getAmr() {
        return this.getEnumListProperty(amrProperty);
    }

    public Date getCreatedAt() {
        return this.getDateProperty(createdAtProperty);
    }

    public Date getExpiresAt() {
        return this.getDateProperty(expiresAtProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public SessionIdentityProvider getIdp() {
        return this.getResourceProperty(idpProperty);
    }

    public Date getLastFactorVerification() {
        return this.getDateProperty(lastFactorVerificationProperty);
    }

    public Date getLastPasswordVerification() {
        return this.getDateProperty(lastPasswordVerificationProperty);
    }

    public String getLogin() {
        return this.getString(loginProperty);
    }

    public SessionStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public String getUserId() {
        return this.getString(userIdProperty);
    }

    public Session refresh() {
        String sessionId = this.getId();
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        String href = "/api/v1/sessions/" + sessionId + "/lifecycle/refresh";
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), this, Session.class);
    }

    @Override
    public void delete() {
        String sessionId = this.getId();
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        String href = "/api/v1/sessions/" + sessionId + "";
        this.getDataStore().delete(href, this);
    }
}

