/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.ds.DefaultDataStore;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.RequestExecutor;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Classes;
import com.okta.sdk.resource.Resource;
import java.lang.reflect.Constructor;

public abstract class AbstractClient
implements Client {
    private final InternalDataStore dataStore;

    public AbstractClient(ClientCredentialsResolver clientCredentialsResolver, BaseUrlResolver baseUrlResolver, Proxy proxy, CacheManager cacheManager, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        Assert.notNull((Object)clientCredentialsResolver, (String)"clientCredentialsResolver argument cannot be null.");
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver argument cannot be null.");
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"connectionTimeout cannot be a negative number.");
        RequestExecutor requestExecutor = this.createRequestExecutor(clientCredentialsResolver.getClientCredentials(), proxy, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
        this.dataStore = this.createDataStore(requestExecutor, baseUrlResolver, clientCredentialsResolver, cacheManager);
    }

    protected InternalDataStore createDataStore(RequestExecutor requestExecutor, BaseUrlResolver baseUrlResolver, ClientCredentialsResolver clientCredentialsResolver, CacheManager cacheManager) {
        return new DefaultDataStore(requestExecutor, baseUrlResolver, clientCredentialsResolver, cacheManager);
    }

    public ClientCredentials getClientCredentials() {
        return this.dataStore.getClientCredentials();
    }

    public CacheManager getCacheManager() {
        return this.dataStore.getCacheManager();
    }

    public InternalDataStore getDataStore() {
        return this.dataStore;
    }

    protected RequestExecutor createRequestExecutor(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        String className = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor";
        if (!Classes.isAvailable((String)className)) {
            String msg = "Unable to find the '" + className + "' implementation on the classpath.  Please ensure you have added the okta-sdk-httpclient .jar file to your runtime classpath.";
            throw new RuntimeException(msg);
        }
        Class requestExecutorClass = Classes.forName((String)className);
        Constructor ctor = Classes.getConstructor((Class)requestExecutorClass, (Class[])new Class[]{ClientCredentials.class, Proxy.class, AuthenticationScheme.class, RequestAuthenticatorFactory.class, Integer.class});
        return (RequestExecutor)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{clientCredentials, proxy, authenticationScheme, requestAuthenticatorFactory, connectionTimeout});
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return (T)this.dataStore.instantiate(clazz);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return (T)this.dataStore.getResource(href, clazz);
    }
}

