/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.group.rule;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleAction;
import com.okta.sdk.resource.group.rule.GroupRuleConditions;
import com.okta.sdk.resource.group.rule.GroupRuleStatus;
import java.util.Date;
import java.util.Map;

public class DefaultGroupRule
extends AbstractInstanceResource<GroupRule>
implements GroupRule {
    private static final ResourceReference<GroupRuleAction> actionsProperty = new ResourceReference<GroupRuleAction>("actions", GroupRuleAction.class, false);
    private static final ResourceReference<GroupRuleConditions> conditionsProperty = new ResourceReference<GroupRuleConditions>("conditions", GroupRuleConditions.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final EnumProperty<GroupRuleStatus> statusProperty = new EnumProperty<GroupRuleStatus>("status", GroupRuleStatus.class);
    private static final StringProperty typeProperty = new StringProperty("type");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroupRule.createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, typeProperty);

    public DefaultGroupRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroupRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public GroupRuleAction getActions() {
        return this.getResourceProperty(actionsProperty);
    }

    public GroupRule setActions(GroupRuleAction actions) {
        this.setProperty(actionsProperty, (Object)actions);
        return this;
    }

    public GroupRuleConditions getConditions() {
        return this.getResourceProperty(conditionsProperty);
    }

    public GroupRule setConditions(GroupRuleConditions conditions) {
        this.setProperty(conditionsProperty, (Object)conditions);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public GroupRule setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public GroupRuleStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public GroupRule setStatus(GroupRuleStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public String getType() {
        return this.getString(typeProperty);
    }

    public GroupRule setType(String type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public void activate() {
        String ruleId = this.getId();
        String href = "/api/v1/groups/rules/" + ruleId + "/lifecycle/activate";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public void delete(Boolean removeUsers) {
        String ruleId = this.getId();
        QueryString queryArgs = new QueryString();
        if (removeUsers != null) {
            queryArgs.put("removeUsers", removeUsers);
        }
        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        this.getDataStore().delete(href);
    }

    @Override
    public void delete() {
        String ruleId = this.getId();
        String href = "/api/v1/groups/rules/" + ruleId + "";
        this.getDataStore().delete(href);
    }

    public void deactivate() {
        String ruleId = this.getId();
        String href = "/api/v1/groups/rules/" + ruleId + "/lifecycle/deactivate";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public GroupRule update() {
        String ruleId = this.getId();
        String href = "/api/v1/groups/rules/" + ruleId + "";
        this.getDataStore().save(href, this);
        return this;
    }
}

