/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.application;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentials;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.ApplicationLicensing;
import com.okta.sdk.resource.application.ApplicationSettings;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DefaultApplication
extends AbstractInstanceResource<Application>
implements Application {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<ApplicationAccessibility> accessibilityProperty = new ResourceReference<ApplicationAccessibility>("accessibility", ApplicationAccessibility.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<ApplicationCredentials> credentialsProperty = new ResourceReference<ApplicationCredentials>("credentials", ApplicationCredentials.class, false);
    private static final ListProperty featuresProperty = new ListProperty("features");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty labelProperty = new StringProperty("label");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final ResourceReference<ApplicationLicensing> licensingProperty = new ResourceReference<ApplicationLicensing>("licensing", ApplicationLicensing.class, false);
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final ResourceReference<ApplicationSettings> settingsProperty = new ResourceReference<ApplicationSettings>("settings", ApplicationSettings.class, false);
    private static final EnumProperty<ApplicationSignOnMode> signOnModeProperty = new EnumProperty<ApplicationSignOnMode>("signOnMode", ApplicationSignOnMode.class);
    private static final EnumProperty<Application.StatusEnum> statusProperty = new EnumProperty<Application.StatusEnum>("status", Application.StatusEnum.class);
    private static final ResourceReference<ApplicationVisibility> visibilityProperty = new ResourceReference<ApplicationVisibility>("visibility", ApplicationVisibility.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultApplication.createPropertyDescriptorMap(embeddedProperty, linksProperty, accessibilityProperty, createdProperty, credentialsProperty, featuresProperty, idProperty, labelProperty, lastUpdatedProperty, licensingProperty, nameProperty, settingsProperty, signOnModeProperty, statusProperty, visibilityProperty);

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Application setEmbedded(Map<String, Object> embedded) {
        this.setProperty(embeddedProperty, embedded);
        return this;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Application setLinks(Map<String, Object> links) {
        this.setProperty(linksProperty, links);
        return this;
    }

    public ApplicationAccessibility getAccessibility() {
        return this.getResourceProperty(accessibilityProperty);
    }

    public Application setAccessibility(ApplicationAccessibility accessibility) {
        this.setProperty(accessibilityProperty, (Object)accessibility);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public ApplicationCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public Application setCredentials(ApplicationCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public List<String> getFeatures() {
        return this.getListProperty(featuresProperty);
    }

    public Application setFeatures(List<String> features) {
        this.setProperty(featuresProperty, features);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getLabel() {
        return this.getString(labelProperty);
    }

    public Application setLabel(String label) {
        this.setProperty(labelProperty, (Object)label);
        return this;
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public ApplicationLicensing getLicensing() {
        return this.getResourceProperty(licensingProperty);
    }

    public Application setLicensing(ApplicationLicensing licensing) {
        this.setProperty(licensingProperty, (Object)licensing);
        return this;
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public ApplicationSettings getSettings() {
        return this.getResourceProperty(settingsProperty);
    }

    public Application setSettings(ApplicationSettings settings) {
        this.setProperty(settingsProperty, (Object)settings);
        return this;
    }

    public ApplicationSignOnMode getSignOnMode() {
        return this.getEnumProperty(signOnModeProperty);
    }

    public Application setSignOnMode(ApplicationSignOnMode signOnMode) {
        this.setProperty(signOnModeProperty, (Object)signOnMode);
        return this;
    }

    public Application.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public ApplicationVisibility getVisibility() {
        return this.getResourceProperty(visibilityProperty);
    }

    public Application setVisibility(ApplicationVisibility visibility) {
        this.setProperty(visibilityProperty, (Object)visibility);
        return this;
    }

    public void activate() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/lifecycle/activate";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId, ApplicationGroupAssignment applicationGroupAssignment) {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        this.getDataStore().save(href, applicationGroupAssignment);
        return applicationGroupAssignment;
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId, String expand) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/groups/" + groupId + "", queryArgs);
        return (ApplicationGroupAssignment)this.getDataStore().getResource(href, ApplicationGroupAssignment.class);
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId) {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        return (ApplicationGroupAssignment)this.getDataStore().getResource(href, ApplicationGroupAssignment.class);
    }

    public AppUser getApplicationUser(String userId, String expand) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/users/" + userId + "", queryArgs);
        return (AppUser)this.getDataStore().getResource(href, AppUser.class);
    }

    public AppUser getApplicationUser(String userId) {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/users/" + userId + "";
        return (AppUser)this.getDataStore().getResource(href, AppUser.class);
    }

    public JsonWebKey cloneApplicationKey(String keyId, String targetAid) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (targetAid != null) {
            queryArgs.put("targetAid", targetAid);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "/clone", queryArgs);
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), JsonWebKey.class);
    }

    public JsonWebKey generateApplicationKey(Integer validityYears) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (validityYears != null) {
            queryArgs.put("validityYears", validityYears);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/credentials/keys/generate", queryArgs);
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), JsonWebKey.class);
    }

    public void deactivate() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/lifecycle/deactivate";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public Application update() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "";
        this.getDataStore().save(href, this);
        return this;
    }

    public JsonWebKeyList listKeys() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/credentials/keys";
        return (JsonWebKeyList)this.getDataStore().getResource(href, JsonWebKeyList.class);
    }

    public ApplicationGroupAssignmentList listGroupAssignments(String q, String expand) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/groups", queryArgs);
        return (ApplicationGroupAssignmentList)this.getDataStore().getResource(href, ApplicationGroupAssignmentList.class);
    }

    public ApplicationGroupAssignmentList listGroupAssignments() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/groups";
        return (ApplicationGroupAssignmentList)this.getDataStore().getResource(href, ApplicationGroupAssignmentList.class);
    }

    public AppUserList listApplicationUsers(String q, String queryScope, String filter, String expand) {
        String appId = this.getId();
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (queryScope != null) {
            queryArgs.put("query_scope", queryScope);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/users", queryArgs);
        return (AppUserList)this.getDataStore().getResource(href, AppUserList.class);
    }

    public AppUserList listApplicationUsers() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/users";
        return (AppUserList)this.getDataStore().getResource(href, AppUserList.class);
    }

    public JsonWebKey getApplicationKey(String keyId) {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "";
        return (JsonWebKey)this.getDataStore().getResource(href, JsonWebKey.class);
    }

    public AppUser assignUserToApplication(AppUser appUser) {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "/users";
        this.getDataStore().create(href, appUser, appUser.getClass());
        return appUser;
    }

    @Override
    public void delete() {
        String appId = this.getId();
        String href = "/api/v1/apps/" + appId + "";
        this.getDataStore().delete(href);
    }
}

