/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds.cache;

import com.okta.sdk.ds.DataStore;
import com.okta.sdk.impl.ds.DefaultResourceDataResult;
import com.okta.sdk.impl.ds.FilterChain;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.ds.cache.AbstractCacheFilter;
import com.okta.sdk.impl.ds.cache.CacheResolver;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCacheFilter
extends AbstractCacheFilter {
    private static final Logger cacheLog = LoggerFactory.getLogger((String)(DataStore.class.getName() + "-cache"));

    public ReadCacheFilter(CacheResolver cacheResolver, boolean collectionCachingEnabled) {
        super(cacheResolver, collectionCachingEnabled);
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result;
        if (this.isCacheRetrievalEnabled(request) && (result = this.getCachedResourceData(request)) != null) {
            return result;
        }
        return chain.filter(request);
    }

    private ResourceDataResult getCachedResourceData(ResourceDataRequest request) {
        CanonicalUri uri = request.getUri();
        Class<? extends Resource> clazz = request.getResourceClass();
        Map<String, ?> data = null;
        String cacheKey = this.getCacheKey(request);
        if (!request.getUri().hasQuery() || !(request.getUri().getQuery().containsKey("expand") ^ (cacheKey != null && cacheKey.contains("expand=")))) {
            data = this.getCachedValue(cacheKey, clazz);
        }
        if (Collections.isEmpty(data)) {
            return null;
        }
        if (cacheLog.isTraceEnabled()) {
            cacheLog.trace("Executing cache request: action: '{}', uri: {}", (Object)request.getAction(), (Object)request.getUri().getAbsolutePath());
        }
        return new DefaultResourceDataResult(request.getAction(), uri, clazz, ReadCacheFilter.coerce(data));
    }

    private static Map<String, Object> coerce(Map<String, ?> data) {
        return data;
    }

    private boolean isCacheRetrievalEnabled(ResourceDataRequest request) {
        Class<? extends Resource> clazz = request.getResourceClass();
        return request.getAction() == ResourceAction.READ && !CollectionResource.class.isAssignableFrom(clazz) || CollectionResource.class.isAssignableFrom(clazz) && this.isCollectionCachingEnabled();
    }
}

