/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.ds.ResourceFactory;
import com.okta.sdk.lang.Classes;
import com.okta.sdk.resource.Resource;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class DefaultResourceFactory
implements ResourceFactory {
    private InternalDataStore dataStore;
    private static final String BASE_PACKAGE = "com.okta.sdk.";
    private static final String IMPL_PACKAGE_NAME_FRAGMENT = "impl";
    private static final String IMPL_PACKAGE_NAME = "impl.";
    private static final String IMPL_CLASS_PREFIX = "Default";

    public DefaultResourceFactory(InternalDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Object ... constructorArgs) {
        if (clazz == null) {
            throw new NullPointerException("Resource class cannot be null.");
        }
        Class<T> implClass = DefaultResourceFactory.getImplementationClass(clazz);
        Object[] ctorArgs = this.createConstructorArgs(constructorArgs);
        Constructor ctor = ctorArgs.length == 1 ? Classes.getConstructor(implClass, (Class[])new Class[]{InternalDataStore.class}) : (ctorArgs.length == 2 ? Classes.getConstructor(implClass, (Class[])new Class[]{InternalDataStore.class, Map.class}) : Classes.getConstructor(implClass, (Class[])new Class[]{InternalDataStore.class, Map.class, Map.class}));
        return (T)((Resource)Classes.instantiate((Constructor)ctor, (Object[])ctorArgs));
    }

    public static <T extends Resource> Class<T> getImplementationClass(Class<T> clazz) {
        if (clazz.isInterface()) {
            return DefaultResourceFactory.convertToImplClass(clazz);
        }
        return clazz;
    }

    public static <T extends Resource> Class<T> getInterfaceClass(Class<T> clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        return DefaultResourceFactory.convertToInterfaceClass(clazz);
    }

    static <T extends Resource> Class<T> convertToInterfaceClass(Class<T> clazz) {
        String fqcn = clazz.getName();
        String afterBase = fqcn.substring(BASE_PACKAGE.length());
        if (afterBase.startsWith(IMPL_PACKAGE_NAME)) {
            afterBase = afterBase.substring(IMPL_PACKAGE_NAME.length());
        }
        int index = afterBase.lastIndexOf(46);
        String beforeSimpleName = afterBase.substring(0, index);
        String simpleName = clazz.getSimpleName();
        index = simpleName.indexOf(IMPL_CLASS_PREFIX);
        simpleName = simpleName.substring(index + IMPL_CLASS_PREFIX.length());
        String ifaceFqcn = BASE_PACKAGE + beforeSimpleName + "." + simpleName;
        return Classes.forName((String)ifaceFqcn);
    }

    static <T extends Resource> Class<T> convertToImplClass(Class<T> clazz) {
        String fqcn = clazz.getName();
        String afterBase = fqcn.substring(BASE_PACKAGE.length());
        if (afterBase.startsWith(IMPL_PACKAGE_NAME)) {
            afterBase = afterBase.substring(IMPL_PACKAGE_NAME.length());
        }
        int index = afterBase.lastIndexOf(46);
        String beforeConcreteClassName = afterBase.substring(0, index);
        String implFqcn = "com.okta.sdk.impl." + beforeConcreteClassName + "." + IMPL_CLASS_PREFIX + clazz.getSimpleName();
        return Classes.forName((String)implFqcn);
    }

    private Object[] createConstructorArgs(Object[] existing) {
        int argsLength = existing != null ? existing.length : 0;
        ArrayList<InternalDataStore> args = new ArrayList<InternalDataStore>(++argsLength);
        args.add(this.dataStore);
        if (existing != null) {
            Collections.addAll(args, existing);
        }
        return args.toArray();
    }
}

