/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.ds.DataStore;
import com.okta.sdk.error.Error;
import com.okta.sdk.http.HttpMethod;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.cache.DisabledCacheManager;
import com.okta.sdk.impl.ds.DefaultCacheRegionNameResolver;
import com.okta.sdk.impl.ds.DefaultFilterChain;
import com.okta.sdk.impl.ds.DefaultResourceConverter;
import com.okta.sdk.impl.ds.DefaultResourceDataRequest;
import com.okta.sdk.impl.ds.DefaultResourceDataResult;
import com.okta.sdk.impl.ds.DefaultResourceFactory;
import com.okta.sdk.impl.ds.Filter;
import com.okta.sdk.impl.ds.FilterChain;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.ds.JacksonMapMarshaller;
import com.okta.sdk.impl.ds.MapMarshaller;
import com.okta.sdk.impl.ds.ProviderAccountResultFilter;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceConverter;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.ds.ResourceFactory;
import com.okta.sdk.impl.ds.cache.CacheResolver;
import com.okta.sdk.impl.ds.cache.DefaultCacheResolver;
import com.okta.sdk.impl.ds.cache.ReadCacheFilter;
import com.okta.sdk.impl.ds.cache.WriteCacheFilter;
import com.okta.sdk.impl.error.DefaultError;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.HttpHeadersHolder;
import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.QueryStringFactory;
import com.okta.sdk.impl.http.Request;
import com.okta.sdk.impl.http.RequestExecutor;
import com.okta.sdk.impl.http.Response;
import com.okta.sdk.impl.http.support.DefaultCanonicalUri;
import com.okta.sdk.impl.http.support.DefaultRequest;
import com.okta.sdk.impl.http.support.UserAgent;
import com.okta.sdk.impl.query.DefaultCriteria;
import com.okta.sdk.impl.query.DefaultOptions;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.ReferenceFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.impl.util.DefaultBaseUrlResolver;
import com.okta.sdk.impl.util.StringInputStream;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.lang.Strings;
import com.okta.sdk.query.Criteria;
import com.okta.sdk.query.Options;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.ResourceException;
import com.okta.sdk.resource.VoidResource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStore
implements InternalDataStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStore.class);
    private static final Logger requestLog = LoggerFactory.getLogger((String)(DataStore.class.getName() + "-request"));
    public static final String DEFAULT_SERVER_HOST = "api.okta.com";
    public static final int DEFAULT_API_VERSION = 1;
    private static final String APPEND_PARAM_CHAR = "&";
    public static final String DEFAULT_CRITERIA_MSG = "The " + DefaultDataStore.class.getName() + " implementation only functions with " + DefaultCriteria.class.getName() + " instances.";
    public static final String DEFAULT_OPTIONS_MSG = "The " + DefaultDataStore.class.getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances.";
    public static final String HREF_REQD_MSG = "'save' may only be called on objects that have already been persisted and have an existing 'href' attribute.";
    private static final boolean COLLECTION_CACHING_ENABLED = false;
    private final RequestExecutor requestExecutor;
    private final ResourceFactory resourceFactory;
    private final MapMarshaller mapMarshaller;
    private final CacheManager cacheManager;
    private final CacheResolver cacheResolver;
    private final ResourceConverter resourceConverter;
    private final QueryStringFactory queryStringFactory;
    private final List<Filter> filters;
    private final ClientCredentialsResolver clientCredentialsResolver;
    private final BaseUrlResolver baseUrlResolver;
    public static final String USER_AGENT_STRING = UserAgent.getUserAgentString();

    public DefaultDataStore(RequestExecutor requestExecutor, ClientCredentialsResolver clientCredentialsResolver) {
        this(requestExecutor, 1, clientCredentialsResolver);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, int apiVersion, ClientCredentialsResolver clientCredentialsResolver) {
        this(requestExecutor, "https://api.okta.com/v" + apiVersion, clientCredentialsResolver);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, String baseUrl, ClientCredentialsResolver clientCredentialsResolver) {
        this(requestExecutor, new DefaultBaseUrlResolver(baseUrl), clientCredentialsResolver, new DisabledCacheManager());
    }

    public DefaultDataStore(RequestExecutor requestExecutor, BaseUrlResolver baseUrlResolver, ClientCredentialsResolver clientCredentialsResolver, CacheManager cacheManager) {
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver cannot be null");
        Assert.notNull((Object)requestExecutor, (String)"RequestExecutor cannot be null.");
        Assert.notNull((Object)clientCredentialsResolver, (String)"clientCredentialsResolver cannot be null.");
        Assert.notNull((Object)cacheManager, (String)"CacheManager cannot be null.  Use the DisabledCacheManager if you wish to turn off caching.");
        this.requestExecutor = requestExecutor;
        this.baseUrlResolver = baseUrlResolver;
        this.cacheManager = cacheManager;
        this.resourceFactory = new DefaultResourceFactory(this);
        this.mapMarshaller = new JacksonMapMarshaller();
        this.queryStringFactory = new QueryStringFactory();
        this.cacheResolver = new DefaultCacheResolver(this.cacheManager, new DefaultCacheRegionNameResolver());
        this.clientCredentialsResolver = clientCredentialsResolver;
        ReferenceFactory referenceFactory = new ReferenceFactory();
        this.resourceConverter = new DefaultResourceConverter(referenceFactory);
        this.filters = new ArrayList<Filter>();
        if (this.isCachingEnabled()) {
            this.filters.add(new ReadCacheFilter(this.cacheResolver, false));
            this.filters.add(new WriteCacheFilter(this.baseUrlResolver, this.cacheResolver, false, referenceFactory));
        }
        this.filters.add(new ProviderAccountResultFilter());
    }

    @Override
    public CacheResolver getCacheResolver() {
        return this.cacheResolver;
    }

    public ClientCredentials getClientCredentials() {
        return this.clientCredentialsResolver.getClientCredentials();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return this.resourceFactory.instantiate(clazz, new Object[0]);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties) {
        return this.resourceFactory.instantiate(clazz, properties);
    }

    private <T extends Resource> T instantiate(Class<T> clazz, Map<String, ?> properties, QueryString qs) {
        if (CollectionResource.class.isAssignableFrom(clazz)) {
            return this.resourceFactory.instantiate(clazz, properties, qs);
        }
        return this.resourceFactory.instantiate(clazz, properties);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties, boolean hrefFragment) {
        if (hrefFragment) {
            Assert.hasText((String)((String)properties.get("href")), (String)"when hrefFragment is set to true the properties map must contain an href key.");
            String hrefValue = (String)properties.get("href");
            hrefValue = this.qualify(hrefValue);
            properties.put("href", hrefValue);
        }
        return this.instantiate(clazz, properties);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return this.getResource(href, clazz, (Options)null);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Criteria criteria) {
        Assert.isInstanceOf(DefaultCriteria.class, (Object)criteria, (String)DEFAULT_CRITERIA_MSG);
        QueryString qs = this.queryStringFactory.createQueryString(href, (DefaultCriteria)criteria);
        return this.getResource(href, clazz, (Options)qs);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Map<String, Object> queryParameters) {
        ResourceDataResult result = this.getResourceData(href, clazz, queryParameters);
        T resource = this.instantiate(clazz, result.getData(), result.getUri().getQuery());
        resource.setResourceHref(href);
        return resource;
    }

    @Override
    public <T extends Resource, R extends T> R getResource(String href, Class<T> parent, String childIdProperty, Map<String, Class<? extends R>> idClassMap) {
        Assert.hasText((String)childIdProperty, (String)"childIdProperty cannot be null or empty.");
        Assert.notEmpty(idClassMap, (String)"idClassMap cannot be null or empty.");
        ResourceDataResult result = this.getResourceData(href, parent, null);
        Map<String, Object> data = result.getData();
        if (Collections.isEmpty(data) || !data.containsKey(childIdProperty)) {
            throw new IllegalStateException(childIdProperty + " could not be found in: " + data + ".");
        }
        Object propertyValue = data.get(childIdProperty);
        if (propertyValue == null) {
            throw new IllegalStateException("No Class mapping could be found for " + childIdProperty + ".");
        }
        Class<? extends R> childClass = idClassMap.get(propertyValue.toString());
        return this.instantiate(childClass, data, result.getUri().getQuery());
    }

    public <T extends Resource, O extends Options> T getResource(String href, Class<T> clazz, O options) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        Assert.isInstanceOf(DefaultOptions.class, options, (String)("The " + this.getClass().getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances."));
        DefaultOptions defaultOptions = (DefaultOptions)options;
        QueryString qs = this.queryStringFactory.createQueryString(defaultOptions);
        return this.getResource(href, clazz, (O)qs);
    }

    private ResourceDataResult getResourceData(String href, Class<? extends Resource> clazz, Map<String, ?> queryParameters) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest req) {
                CanonicalUri uri = req.getUri();
                DefaultRequest getRequest = new DefaultRequest(HttpMethod.GET, uri.getAbsolutePath(), uri.getQuery());
                Response getResponse = DefaultDataStore.this.execute(getRequest);
                Map body = DefaultDataStore.this.getBody(getResponse);
                if (Collections.isEmpty((Map)body)) {
                    throw new IllegalStateException("Unable to obtain resource data from the API server or from cache.");
                }
                return new DefaultResourceDataResult(req.getAction(), uri, req.getResourceClass(), body);
            }
        });
        CanonicalUri uri = this.canonicalize(href, queryParameters);
        DefaultResourceDataRequest req = new DefaultResourceDataRequest(ResourceAction.READ, uri, clazz, new HashMap<String, Object>());
        return chain.filter(req);
    }

    private ResourceAction getPostAction(ResourceDataRequest request, Response response) {
        int httpStatus = response.getHttpStatus();
        if (httpStatus == 201) {
            return ResourceAction.CREATE;
        }
        if (httpStatus == 200) {
            return ResourceAction.READ;
        }
        return request.getAction();
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource) {
        return (T)this.save(parentHref, resource, null, resource.getClass(), null, true);
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource, Options options) {
        QueryString qs = this.toQueryString(parentHref, options);
        return (T)this.save(parentHref, resource, null, resource.getClass(), qs, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType) {
        return this.save(parentHref, resource, null, returnType, null, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType, HttpHeaders requestHeaders) {
        return this.save(parentHref, resource, requestHeaders, returnType, null, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType, Options options) {
        QueryString qs = this.toQueryString(parentHref, options);
        return this.save(parentHref, resource, null, returnType, qs, true);
    }

    @Override
    public <T extends Resource> void save(T resource) {
        this.save(resource.getResourceHref(), resource);
    }

    @Override
    public <T extends Resource> void save(String href, T resource) {
        Assert.hasText((String)href, (String)HREF_REQD_MSG);
        this.save(href, resource, null, resource.getClass(), null, false);
    }

    @Override
    public <T extends Resource> void save(T resource, Options options) {
        Assert.notNull((Object)options, (String)"options argument cannot be null.");
        String href = resource.getResourceHref();
        Assert.hasText((String)href, (String)HREF_REQD_MSG);
        QueryString qs = this.toQueryString(href, options);
        this.save(href, resource, null, resource.getClass(), qs, false);
    }

    @Override
    public <T extends Resource, R extends Resource> R save(T resource, Class<? extends R> returnType) {
        Assert.hasText((String)resource.getResourceHref(), (String)HREF_REQD_MSG);
        return this.save(resource.getResourceHref(), resource, null, returnType, null, false);
    }

    private QueryString toQueryString(String href, Options options) {
        if (options == null) {
            return null;
        }
        Assert.isInstanceOf(DefaultOptions.class, (Object)options, (String)DEFAULT_OPTIONS_MSG);
        DefaultOptions defaultOptions = (DefaultOptions)options;
        return this.queryStringFactory.createQueryString(href, defaultOptions);
    }

    private <T extends Resource, R extends Resource> R save(String href, final T resource, HttpHeaders requestHeaders, final Class<? extends R> returnType, QueryString qs, final boolean create) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.notNull(returnType, (String)"returnType class cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.isTrue((!CollectionResource.class.isAssignableFrom(resource.getClass()) ? 1 : 0) != 0, (String)"Collections cannot be persisted.");
        CanonicalUri uri = this.canonicalize(href, qs);
        AbstractResource abstractResource = (AbstractResource)resource;
        Map<String, Object> props = this.resourceConverter.convert(abstractResource, false);
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest req) {
                DefaultRequest request;
                Response response;
                Map<String, Object> responseBody;
                String bodyString = req.getHttpHeaders().getContentType() != null && req.getHttpHeaders().getContentType().equals(MediaType.APPLICATION_FORM_URLENCODED) ? DefaultDataStore.this.buildCanonicalBodyQueryParams(req.getData()) : (resource instanceof VoidResource ? "" : DefaultDataStore.this.mapMarshaller.marshal(req.getData()));
                StringInputStream body = new StringInputStream(bodyString);
                long length = body.available();
                CanonicalUri uri = req.getUri();
                String href = uri.getAbsolutePath();
                QueryString qs = uri.getQuery();
                HttpHeaders httpHeaders = req.getHttpHeaders();
                HttpMethod method = HttpMethod.POST;
                if (!create) {
                    method = HttpMethod.PUT;
                }
                if (Collections.isEmpty((Map)(responseBody = DefaultDataStore.this.getBody(response = DefaultDataStore.this.execute(request = new DefaultRequest(method, href, qs, httpHeaders, body, length)))))) {
                    if (response.getHttpStatus() == 202 || response.getHttpStatus() == 200 || response.getHttpStatus() == 204) {
                        responseBody = java.util.Collections.emptyMap();
                    } else {
                        throw new IllegalStateException("Unable to obtain resource data from the API server.");
                    }
                }
                ResourceAction responseAction = DefaultDataStore.this.getPostAction(req, response);
                return new DefaultResourceDataResult(responseAction, uri, returnType, responseBody);
            }
        });
        ResourceAction action = create ? ResourceAction.CREATE : ResourceAction.UPDATE;
        DefaultResourceDataRequest request = new DefaultResourceDataRequest(action, uri, abstractResource.getClass(), props, requestHeaders);
        ResourceDataResult result = chain.filter(request);
        Map<String, Object> data = result.getData();
        if (returnType.equals(abstractResource.getClass())) {
            abstractResource.setInternalProperties(data);
        }
        return this.resourceFactory.instantiate(returnType, data);
    }

    @Override
    public void delete(String href) {
        this.doDelete(href, VoidResource.class, null);
    }

    @Override
    public <T extends Resource> void delete(T resource) {
        this.doDelete(resource, null);
    }

    @Override
    public <T extends Resource> void deleteResourceProperty(T resource, String propertyName) {
        Assert.hasText((String)propertyName, (String)"propertyName cannot be null or empty.");
        this.doDelete(resource, propertyName);
    }

    private String buildCanonicalBodyQueryParams(Map<String, Object> bodyData) {
        StringBuilder builder = new StringBuilder();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(bodyData);
        try {
            for (Map.Entry entry : treeMap.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (builder.length() > 0) {
                    builder.append(APPEND_PARAM_CHAR);
                }
                builder.append(String.format("%s=%s", URLEncoder.encode((String)entry.getKey(), "UTF-8"), URLEncoder.encode(value.toString(), "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.trace("Body content could not be properly encoded");
            return null;
        }
        return builder.toString();
    }

    private void doDelete(String resourceHref, Class resourceClass, String possiblyNullPropertyName) {
        Assert.hasText((String)resourceHref, (String)"This resource does not have an href value, therefore it cannot be deleted.");
        if (resourceHref.startsWith("/")) {
            resourceHref = this.qualify(resourceHref);
        }
        final String requestHref = Strings.hasText((String)possiblyNullPropertyName) ? resourceHref + "/" + possiblyNullPropertyName : resourceHref;
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest request) {
                DefaultRequest deleteRequest = new DefaultRequest(HttpMethod.DELETE, requestHref);
                DefaultDataStore.this.execute(deleteRequest);
                return new DefaultResourceDataResult(request.getAction(), request.getUri(), request.getResourceClass(), new HashMap<String, Object>());
            }
        });
        CanonicalUri resourceUri = this.canonicalize(resourceHref, null);
        DefaultResourceDataRequest request = new DefaultResourceDataRequest(ResourceAction.DELETE, resourceUri, resourceClass, new HashMap<String, Object>());
        chain.filter(request);
    }

    private <T extends Resource> void doDelete(T resource, String possiblyNullPropertyName) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource, (String)"Resource argument must be an AbstractResource.");
        this.doDelete(resource.getResourceHref(), resource.getClass(), possiblyNullPropertyName);
    }

    public boolean isCachingEnabled() {
        return this.cacheManager != null && !(this.cacheManager instanceof DisabledCacheManager);
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrlResolver.getBaseUrl();
    }

    private Response execute(Request request) throws ResourceException {
        this.applyDefaultRequestHeaders(request);
        Response response = this.requestExecutor.executeRequest(request);
        log.trace("Executed HTTP request.");
        if (requestLog.isTraceEnabled()) {
            requestLog.trace("Executing request: method: '{}', url: {}", (Object)request.getMethod(), (Object)request.getResourceUrl());
        }
        if (response.isError()) {
            Map<String, Object> body = this.getBody(response);
            String requestId = response.getHeaders().getOktaRequestId();
            if (Strings.hasText((String)requestId)) {
                body.put(DefaultError.ERROR_ID.getName(), requestId);
            }
            DefaultError error = new DefaultError(body);
            throw new ResourceException((Error)error);
        }
        return response;
    }

    private Map<String, Object> getBody(Response response) {
        Assert.notNull((Object)response, (String)"response argument cannot be null.");
        Map<String, Object> out = null;
        if (response.hasBody()) {
            out = this.mapMarshaller.unmarshall(response.getBody(), response.getHeaders().getLinkMap());
        }
        return out;
    }

    protected void applyDefaultRequestHeaders(Request request) {
        List<String> clientRequestId;
        request.getHeaders().setAccept(java.util.Collections.singletonList(MediaType.APPLICATION_JSON));
        Map<String, List<String>> headerMap = HttpHeadersHolder.get();
        String oktaAgentHeaderName = "X-Okta-Agent".toLowerCase(Locale.ENGLISH);
        if (headerMap != null && headerMap.get(oktaAgentHeaderName) != null) {
            List<String> oktaAgents = headerMap.get(oktaAgentHeaderName);
            if (oktaAgents != null && oktaAgents.size() > 0) {
                String oktaAgent = Strings.arrayToDelimitedString((Object[])oktaAgents.toArray(), (String)" ");
                request.getHeaders().set("User-Agent", oktaAgent + " " + USER_AGENT_STRING);
            }
        } else {
            request.getHeaders().set("User-Agent", USER_AGENT_STRING);
        }
        if (request.getHeaders().getContentType() == null && request.getBody() != null) {
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        }
        if (headerMap != null && (clientRequestId = headerMap.get("X-Okta-Client-Request-Id")) != null) {
            request.getHeaders().put("X-Okta-Client-Request-Id", clientRequestId);
        }
    }

    protected CanonicalUri canonicalize(String href, Map<String, ?> queryParams) {
        href = this.ensureFullyQualified(href);
        return DefaultCanonicalUri.create(href, queryParams);
    }

    protected String ensureFullyQualified(String href) {
        String value = href;
        if (!this.isFullyQualified(href)) {
            value = this.qualify(href);
        }
        return value;
    }

    protected boolean isFullyQualified(String href) {
        if (href == null || href.length() < 5) {
            return false;
        }
        char c = href.charAt(0);
        return !(c != 'h' && c != 'H' || (c = href.charAt(1)) != 't' && c != 'T' || (c = href.charAt(2)) != 't' && c != 'T' || (c = href.charAt(3)) != 'p' && c != 'P');
    }

    protected String qualify(String href) {
        StringBuilder sb = new StringBuilder(this.baseUrlResolver.getBaseUrl());
        if (!href.startsWith("/")) {
            sb.append("/");
        }
        sb.append(href);
        return sb.toString();
    }
}

