/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http;

import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.support.DefaultCanonicalUri;
import com.okta.sdk.impl.query.DefaultCriteria;
import com.okta.sdk.impl.query.DefaultOptions;
import com.okta.sdk.impl.query.Expansion;
import com.okta.sdk.impl.query.LikeExpression;
import com.okta.sdk.impl.query.Order;
import com.okta.sdk.impl.query.SimpleExpression;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.lang.Strings;
import com.okta.sdk.query.Criterion;
import java.util.List;
import java.util.Map;

public class QueryStringFactory {
    public QueryString createQueryString(String href, DefaultCriteria criteria) {
        QueryString query = this.createQueryString(criteria);
        CanonicalUri uri = DefaultCanonicalUri.create(href, null);
        if (uri.hasQuery()) {
            query.putAll(uri.getQuery());
        }
        return query;
    }

    public QueryString createQueryString(DefaultCriteria criteria) {
        Integer limit;
        Integer offset;
        QueryString qs = new QueryString();
        if (criteria == null || criteria.isEmpty()) {
            return qs;
        }
        List<Criterion> criterionList = criteria.getCriterionEntries();
        List<Order> orderList = criteria.getOrderEntries();
        List<Expansion> expansionList = criteria.getExpansions();
        if (!Collections.isEmpty(criterionList)) {
            this.addCriterionEntries(qs, criterionList);
        }
        if (!orderList.isEmpty()) {
            String orderBy = Strings.collectionToCommaDelimitedString(orderList);
            qs.put("orderBy", orderBy);
        }
        if ((offset = criteria.getOffset()) != null) {
            String value = String.valueOf(offset);
            qs.put("offset", value);
        }
        if ((limit = criteria.getLimit()) != null) {
            String value = String.valueOf(limit);
            qs.put("limit", value);
        }
        this.applyExpansions(qs, expansionList);
        this.applyCustomAttributes(qs, criteria);
        return qs;
    }

    public QueryString createQueryString(String href, DefaultOptions defaultOptions) {
        QueryString query = this.createQueryString(defaultOptions);
        CanonicalUri uri = DefaultCanonicalUri.create(href, null);
        if (uri.hasQuery()) {
            query.putAll(uri.getQuery());
        }
        return query;
    }

    public QueryString createQueryString(DefaultOptions options) {
        QueryString qs = new QueryString();
        List<Expansion> expansions = options.getExpansions();
        this.applyExpansions(qs, expansions);
        return qs;
    }

    private void applyExpansions(QueryString qs, List<Expansion> expansions) {
        if (!Collections.isEmpty(expansions)) {
            String expand = Strings.collectionToCommaDelimitedString(expansions);
            qs.put("expand", expand);
        }
    }

    private void applyCustomAttributes(QueryString qs, DefaultCriteria criteria) {
        if (criteria.hasCustomAttributes()) {
            qs.putAll(criteria.getCustomAttributes());
        }
    }

    public QueryString createQueryString(Map<String, ?> params) {
        if (params instanceof QueryString) {
            return (QueryString)params;
        }
        if (params == null) {
            return new QueryString();
        }
        QueryString qs = new QueryString();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String sValue = String.valueOf(value);
            qs.put(key, sValue);
        }
        return qs;
    }

    private void addCriterionEntries(QueryString qs, List<Criterion> entries) {
        for (Criterion c : entries) {
            Object value;
            String queryParamName;
            if (c instanceof LikeExpression) {
                LikeExpression le = (LikeExpression)c;
                queryParamName = le.getPropertyName();
                value = le.getValue();
                String sValue = String.valueOf(value);
                String queryParamValue = le.getMatchLocation().toMatchString(sValue);
                qs.put(queryParamName, queryParamValue);
                continue;
            }
            if (c instanceof SimpleExpression) {
                SimpleExpression se = (SimpleExpression)c;
                queryParamName = se.getPropertyName();
                value = se.getValue();
                String queryParamValue = String.valueOf(value);
                qs.put(queryParamName, queryParamValue);
                continue;
            }
            throw new IllegalArgumentException("Unexpected Criterion type: " + c);
        }
    }
}

