/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.sdk.impl.ds.ResourceConverter;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.ReferenceFactory;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultResourceConverter
implements ResourceConverter {
    private final ReferenceFactory referenceFactory;

    public DefaultResourceConverter(ReferenceFactory referenceFactory) {
        Assert.notNull((Object)referenceFactory, (String)"referenceFactory cannot be null.");
        this.referenceFactory = referenceFactory;
    }

    @Override
    public Map<String, Object> convert(AbstractResource resource, boolean dirtOnly) {
        Assert.notNull((Object)resource, (String)"resource cannot be null.");
        return this.toMap(resource, dirtOnly);
    }

    private LinkedHashMap<String, Object> toMap(AbstractResource resource, boolean partialUpdate) {
        HashSet<String> propNames = new HashSet<String>();
        propNames.addAll(resource.getUpdatedPropertyNames());
        if (!partialUpdate) {
            propNames.addAll(resource.getPropertyNames());
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(propNames.size());
        for (String propName : propNames) {
            Object value = resource.getProperty(propName);
            value = this.toMapValue(resource, propName, value, partialUpdate);
            props.put(propName, value);
        }
        return props;
    }

    private Object toMapValue(AbstractResource resource, String propName, Object value, boolean dirtyOnly) {
        if (value instanceof AbstractResource) {
            return this.toMap((AbstractResource)value, dirtyOnly);
        }
        if (value instanceof Map) {
            if (Strings.hasText((String)resource.getResourceHref())) {
                return this.referenceFactory.createReference(propName, (Map)value);
            }
            return this.referenceFactory.createUnmaterializedReference(propName, (Map)value);
        }
        return value;
    }
}

