/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds.cache;

import com.okta.sdk.cache.Cache;
import com.okta.sdk.impl.ds.CacheMapInitializer;
import com.okta.sdk.impl.ds.DefaultCacheMapInitializer;
import com.okta.sdk.impl.ds.DefaultResourceFactory;
import com.okta.sdk.impl.ds.FilterChain;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.ds.cache.AbstractCacheFilter;
import com.okta.sdk.impl.ds.cache.CacheResolver;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.ArrayProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ReferenceFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class WriteCacheFilter
extends AbstractCacheFilter {
    private final BaseUrlResolver baseUrlResolver;
    private final ReferenceFactory referenceFactory;
    private final CacheMapInitializer cacheMapInitializer;

    public WriteCacheFilter(BaseUrlResolver baseUrlResolver, CacheResolver cacheResolver, boolean collectionCachingEnabled, ReferenceFactory referenceFactory) {
        super(cacheResolver, collectionCachingEnabled);
        Assert.notNull((Object)referenceFactory, (String)"referenceFactory cannot be null.");
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver cannot be null.");
        this.referenceFactory = referenceFactory;
        this.cacheMapInitializer = new DefaultCacheMapInitializer();
        this.baseUrlResolver = baseUrlResolver;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result;
        if (request.getAction() == ResourceAction.DELETE) {
            String key = this.getCacheKey(request);
            this.uncache(key, request.getResourceClass());
        }
        if (this.isCacheable(request, result = chain.filter(request))) {
            this.cache(result.getResourceClass(), result.getData(), result.getUri());
        }
        return result;
    }

    private boolean isCacheable(ResourceDataRequest request, ResourceDataResult result) {
        if (Collections.isEmpty(result.getData())) {
            return false;
        }
        Class<? extends Resource> clazz = result.getResourceClass();
        return AbstractResource.isMaterialized(result.getData());
    }

    private void cache(Class<? extends Resource> clazz, Map<String, ?> data, CanonicalUri uri) {
        Assert.notEmpty(data, (String)"Resource data cannot be null or empty.");
        String href = uri.getAbsolutePath();
        if (this.isDirectlyCacheable(clazz, data)) {
            Assert.notNull((Object)href, (String)"Resource data must contain an 'href' attribute.");
            Assert.isTrue((data.size() > 1 ? 1 : 0) != 0, (String)"Resource data must be materialized to be cached (need more than just an 'href' attribute).");
        }
        Map<String, Object> cacheValue = this.cacheMapInitializer.initialize(clazz, data, uri.getQuery());
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map nested = (Map)value;
                if (!AbstractResource.isMaterialized(nested)) continue;
            }
            if (!(value instanceof Collection) || !name.equals("items") || data.get("href") == null) continue;
            Collection c = (Collection)value;
            ArrayList list = new ArrayList(c.size());
            Property property = this.getPropertyDescriptor(clazz, name);
            boolean isCollection = property instanceof ArrayProperty;
            Assert.isTrue((boolean)isCollection, (String)"It is expected that only ArrayProperty or SetProperty properties represent collection items.");
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                Map referenceData;
                Object o;
                Object element = o = iterator.next();
                if (o instanceof Map && AbstractResource.isMaterialized(referenceData = (Map)o)) {
                    element = this.toCanonicalReference(null, referenceData);
                }
                list.add(element);
            }
            value = list;
        }
        if (this.isDirectlyCacheable(clazz, cacheValue)) {
            Cache<String, Map<String, ?>> cache = this.getCache(clazz);
            String cacheKey = this.getCacheKey(href, uri.getQuery(), clazz);
            cache.put((Object)cacheKey, cacheValue);
        }
    }

    private Map<String, ?> toCanonicalReference(String name, Map<String, ?> resourceData) {
        if (AbstractInstanceResource.isInstanceResource(resourceData)) {
            return this.referenceFactory.createReference(name, resourceData);
        }
        return resourceData;
    }

    private <T extends Resource> Property getPropertyDescriptor(Class<T> clazz, String propertyName) {
        Map<String, Property> descriptors = this.getPropertyDescriptors(clazz);
        return descriptors.get(propertyName);
    }

    private <T extends Resource> Map<String, Property> getPropertyDescriptors(Class<T> clazz) {
        Class<T> implClass = DefaultResourceFactory.getImplementationClass(clazz);
        String propertyDescriptors = "PROPERTY_DESCRIPTORS";
        try {
            Field field = implClass.getDeclaredField(propertyDescriptors);
            field.setAccessible(true);
            Map returnValue = (Map)field.get(null);
            while (implClass.getSuperclass() != null && Resource.class.isAssignableFrom(implClass)) {
                implClass = implClass.getSuperclass();
                try {
                    field = implClass.getDeclaredField(propertyDescriptors);
                    field.setAccessible(true);
                    returnValue.putAll((Map)field.get(null));
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to access PROPERTY_DESCRIPTORS static field on implementation class " + clazz.getName(), e);
        }
    }

    private boolean isDirectlyCacheable(Class<? extends Resource> clazz, Map<String, ?> data) {
        return AbstractResource.isMaterialized(data) && (!CollectionResource.class.isAssignableFrom(clazz) || CollectionResource.class.isAssignableFrom(clazz) && this.isCollectionCachingEnabled());
    }

    private void uncache(String cacheKey, Class<? extends Resource> resourceType) {
        Assert.hasText((String)cacheKey, (String)"cacheKey cannot be null or empty.");
        Assert.notNull(resourceType, (String)"resourceType cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(resourceType);
        cache.remove((Object)cacheKey);
    }
}

