/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Clients;
import com.okta.sdk.helper.PaginationUtil;
import com.okta.sdk.resource.api.ApplicationApi;
import com.okta.sdk.resource.api.GroupApi;
import com.okta.sdk.resource.api.PolicyApi;
import com.okta.sdk.resource.api.SystemLogApi;
import com.okta.sdk.resource.api.UserApi;
import com.okta.sdk.resource.api.UserFactorApi;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.BookmarkApplication;
import com.okta.sdk.resource.model.BrowserPluginApplication;
import com.okta.sdk.resource.model.CreateUserRequest;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyType;
import com.okta.sdk.resource.model.SwaApplicationSettings;
import com.okta.sdk.resource.model.SwaApplicationSettingsApplication;
import com.okta.sdk.resource.model.UpdateUserRequest;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserFactorActivateRequest;
import com.okta.sdk.resource.model.UserFactorCall;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorSMS;
import com.okta.sdk.resource.model.UserFactorSMSProfile;
import com.okta.sdk.resource.model.UserFactorType;
import com.okta.sdk.resource.model.UserFactorVerifyRequest;
import com.okta.sdk.resource.model.UserFactorVerifyResponse;
import com.okta.sdk.resource.model.UserProfile;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadmeSnippets {
    private static final Logger log = LoggerFactory.getLogger(ReadmeSnippets.class);
    private final ApiClient client = Clients.builder().build();
    private static final User user = null;

    private void createClient() {
        ApiClient client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setClientCredentials((ClientCredentials)new TokenClientCredentials("{apiToken}")).build();
    }

    private void createOAuth2Client() {
        ApiClient client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setAuthorizationMode(AuthorizationMode.PRIVATE_KEY).setClientId("{clientId}").setKid("{kid}").setScopes(new HashSet<String>(Arrays.asList("okta.users.manage", "okta.apps.manage", "okta.groups.manage"))).setPrivateKey("/path/to/yourPrivateKey.pem").build();
    }

    private void getUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        userApi.getUser("userId", "application/json", "true");
    }

    private void listAllUsers() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, null, null, null, null, null, null, null, null);
        users.stream().forEach(user -> {});
    }

    private void userSearch() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, "profile.email eq \"jcoder@example.com\"", null, null, null, null, null, null, null);
        userApi.listUsers(null, null, null, null, "status eq \"ACTIVE\"", null, null, null, null, null);
    }

    private void createUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(userApi);
    }

    private void createUserWithGroups() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").setGroups(Arrays.asList("groupId-1", "groupId-2")).buildAndCreate(userApi);
    }

    private void updateUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        UpdateUserRequest updateUserRequest = new UpdateUserRequest();
        UserProfile userProfile = new UserProfile();
        userProfile.setNickName("Batman");
        updateUserRequest.setProfile(userProfile);
        userApi.updateUser(user.getId(), updateUserRequest, Boolean.valueOf(true), null);
    }

    private void updateUserWithCustomAttributes() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        UpdateUserRequest updateUserRequest = new UpdateUserRequest();
        UserProfile userProfile = new UserProfile();
        userProfile.getAdditionalProperties().put("foo", "bar");
        updateUserRequest.setProfile(userProfile);
        userApi.updateUser(user.getId(), updateUserRequest, Boolean.valueOf(true), null);
    }

    private void deleteUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        userApi.deleteUser(user.getId(), Boolean.valueOf(false), null);
        userApi.deleteUser(user.getId(), Boolean.valueOf(false), null);
    }

    private void listGroups() throws ApiException {
        GroupApi groupApi = new GroupApi(this.client);
        List groups = groupApi.listGroups(null, null, null, null, null, null, null, null);
    }

    private void createGroup() throws ApiException {
        GroupApi groupApi = new GroupApi(this.client);
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(groupApi);
    }

    private void assignUserToGroup() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(userApi);
        GroupApi groupApi = new GroupApi(this.client);
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(groupApi);
        groupApi.assignUserToGroup(group.getId(), user.getId());
    }

    private void listUserFactors() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        List userFactors = userFactorApi.listFactors("userId");
    }

    private void getUserFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
    }

    private void enrollUserInFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactorSMSProfile UserFactorSMSProfile2 = new UserFactorSMSProfile();
        UserFactorSMSProfile2.setPhoneNumber("555 867 5309");
        UserFactorSMS UserFactorSMS2 = new UserFactorSMS();
        UserFactorSMS2.setProvider(UserFactorProvider.OKTA.name());
        UserFactorSMS2.setFactorType(UserFactorType.SMS);
        UserFactorSMS2.setProfile(UserFactorSMSProfile2);
        userFactorApi.enrollFactor("userId", (UserFactor)UserFactorSMS2, Boolean.valueOf(true), "templateId", Integer.valueOf(30), Boolean.valueOf(true), null);
    }

    private void activateFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactorCall userFactor = (UserFactorCall)userFactorApi.getFactor("userId", "factorId");
        UserFactorActivateRequest userFactorActivateRequest = new UserFactorActivateRequest();
        userFactorActivateRequest.setPassCode("123456");
        userFactorApi.activateFactor("userId", "factorId", userFactorActivateRequest);
    }

    private void verifyFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
        UserFactorVerifyRequest userFactorVerifyRequest = new UserFactorVerifyRequest();
        userFactorVerifyRequest.setPassCode("123456");
        UserFactorVerifyResponse verifyUserFactorResponse = userFactorApi.verifyFactor("userId", "factorId", "templateId", Integer.valueOf(10), "xForwardedFor", "userAgent", "acceptLanguage", userFactorVerifyRequest);
    }

    private void listApplications() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        List applications = applicationApi.listApplications(null, null, Boolean.valueOf(true), null, null, null, null, Boolean.valueOf(true));
    }

    private void getApplication() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        BookmarkApplication bookmarkApp = (BookmarkApplication)applicationApi.getApplication("bookmark-app-id", null);
    }

    private void createSwaApplication() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        SwaApplicationSettingsApplication swaApplicationSettingsApplication = new SwaApplicationSettingsApplication();
        swaApplicationSettingsApplication.buttonField("btn-login").passwordField("txtbox-password").usernameField("txtbox-username").url("https://example.com/login.html");
        SwaApplicationSettings swaApplicationSettings = new SwaApplicationSettings();
        swaApplicationSettings.app(swaApplicationSettingsApplication);
        BrowserPluginApplication browserPluginApplication = new BrowserPluginApplication();
        browserPluginApplication.name(BrowserPluginApplication.NameEnum.TEMPLATE_SWA);
        browserPluginApplication.label("Sample Plugin App");
        browserPluginApplication.settings(swaApplicationSettings);
        BrowserPluginApplication createdApp = (BrowserPluginApplication)applicationApi.createApplication((Application)browserPluginApplication, Boolean.valueOf(true), null);
    }

    private void listPolicies() throws ApiException {
        PolicyApi policyApi = new PolicyApi(this.client);
        List policies = policyApi.listPolicies(PolicyType.PASSWORD.name(), LifecycleStatus.ACTIVE.name(), null, null, null, null, null, null);
    }

    private void getPolicy() throws ApiException {
        PolicyApi policyApi = new PolicyApi(this.client);
        Policy policy = policyApi.getPolicy("policy-id", null);
    }

    private void listSysLogs() throws ApiException {
        SystemLogApi systemLogApi = new SystemLogApi(this.client);
        List logEvents = systemLogApi.listLogEvents(null, null, null, "interestingURI.com", null, Integer.valueOf(100), "ASCENDING");
    }

    private void callAnotherEndpoint() throws ApiException {
        ApiClient apiClient = ReadmeSnippets.buildApiClient("orgBaseUrl", "apiKey");
        String email = "joe.coder+" + UUID.randomUUID() + "@example.com";
        UserProfile userProfile = new UserProfile().firstName("Joe").lastName("Coder").email(email).mobilePhone("1234567890").login(email);
        CreateUserRequest createUserRequest = new CreateUserRequest();
        createUserRequest.setProfile(userProfile);
        ArrayList queryParams = new ArrayList();
        queryParams.addAll(this.client.parameterToPair("activate", (Object)"true"));
        queryParams.addAll(this.client.parameterToPair("provider", null));
        queryParams.addAll(this.client.parameterToPair("nextLogin", null));
        ArrayList collectionQueryParams = new ArrayList();
        HashMap headerParams = new HashMap();
        HashMap cookieParams = new HashMap();
        HashMap formParams = new HashMap();
        TypeReference<User> returnType = new TypeReference<User>(){};
        User user = (User)this.client.invokeAPI("/api/v1/users", "POST", queryParams, collectionQueryParams, new StringJoiner("&").toString(), (Object)createUserRequest, headerParams, cookieParams, formParams, "application/json", "application/json", new String[]{"apiToken", "oauth2"}, (TypeReference)returnType);
    }

    private void paginate() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        ArrayList users = new ArrayList();
        String after = null;
        do {
            users.addAll(userApi.listUsers(null, null, null, null, null, null, null, after, null, null));
        } while (StringUtils.isNotBlank((CharSequence)(after = PaginationUtil.getAfter((ApiClient)userApi.getApiClient()))));
    }

    private void complexCaching() {
        Caches.newCacheManager().withDefaultTimeToLive(300L, TimeUnit.SECONDS).withDefaultTimeToIdle(300L, TimeUnit.SECONDS).withCache(Caches.forResource(User.class).withTimeToLive(1L, TimeUnit.HOURS).withTimeToIdle(30L, TimeUnit.MINUTES)).withCache(Caches.forResource(Group.class).withTimeToLive(1L, TimeUnit.HOURS)).build();
    }

    private void disableCaching() {
        ApiClient client = Clients.builder().setCacheManager(Caches.newDisabledCacheManager()).build();
    }

    private static ApiClient buildApiClient(String orgBaseUrl, String apiKey) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(orgBaseUrl);
        apiClient.setApiKey(apiKey);
        apiClient.setApiKeyPrefix(AuthenticationScheme.SSWS.name());
        return apiClient;
    }
}

