/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.common.PagedList;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openapitools.client.ApiClient;
import org.openapitools.client.api.ApplicationApi;
import org.openapitools.client.api.GroupApi;
import org.openapitools.client.api.SystemLogApi;
import org.openapitools.client.api.UserApi;
import org.openapitools.client.api.UserFactorApi;
import org.openapitools.client.model.ActivateFactorRequest;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.ApplicationSignOnMode;
import org.openapitools.client.model.BookmarkApplication;
import org.openapitools.client.model.BookmarkApplicationSettings;
import org.openapitools.client.model.BookmarkApplicationSettingsApplication;
import org.openapitools.client.model.BrowserPluginApplication;
import org.openapitools.client.model.Group;
import org.openapitools.client.model.SmsUserFactor;
import org.openapitools.client.model.SwaApplicationSettings;
import org.openapitools.client.model.SwaApplicationSettingsApplication;
import org.openapitools.client.model.UpdateUserRequest;
import org.openapitools.client.model.User;
import org.openapitools.client.model.UserFactor;
import org.openapitools.client.model.UserProfile;
import org.openapitools.client.model.VerifyFactorRequest;
import org.openapitools.client.model.VerifyUserFactorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ReadmeSnippets {
    private static final Logger log = LoggerFactory.getLogger(ReadmeSnippets.class);
    private final ApiClient client = Clients.builder().build();
    private final User user = null;

    private void createClient() {
        ApiClient client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setClientCredentials((ClientCredentials)new TokenClientCredentials("{apiToken}")).build();
    }

    private void getUser() {
        UserApi userApi = new UserApi(this.client);
        User user = userApi.getUser("userId");
    }

    private void listAllUsers() {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, Integer.valueOf(5), null, null, null, null);
        users.stream().forEach(user -> {});
    }

    private void userSearch() {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, Integer.valueOf(5), null, "jcoder@example.com", null, null);
        users = userApi.listUsers(null, null, null, "status eq \"ACTIVE\"", null, null, null);
    }

    private void createUser() {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(userApi);
    }

    private void createUserWithGroups() {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").setGroups(Arrays.asList("groupId-1", "groupId-2")).buildAndCreate(userApi);
    }

    private void updateUser() {
        UserApi userApi = new UserApi(this.client);
        UpdateUserRequest updateUserRequest = new UpdateUserRequest();
        UserProfile userProfile = new UserProfile();
        userProfile.setNickName("Batman");
        updateUserRequest.setProfile(userProfile);
        userApi.updateUser(this.user.getId(), updateUserRequest, Boolean.valueOf(true));
    }

    private void deleteUser() {
        UserApi userApi = new UserApi(this.client);
        userApi.deactivateUser(this.user.getId(), Boolean.valueOf(false));
        userApi.deleteUser(this.user.getId(), Boolean.valueOf(false));
    }

    private void listUsersGroup() {
        GroupApi groupApi = new GroupApi(this.client);
        List groups = groupApi.listGroups(null, null, null, Integer.valueOf(10), null, null);
    }

    private void createGroup() {
        GroupApi groupApi = new GroupApi(this.client);
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(groupApi);
    }

    private void listUserFactors() {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        List userFactors = userFactorApi.listFactors("userId");
    }

    private void enrollUserInFactor() {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        SmsUserFactor smsFactor = new SmsUserFactor();
        smsFactor.getProfile().setPhoneNumber("555 867 5309");
        UserFactor userFactor = userFactorApi.enrollFactor("userId", (UserFactor)smsFactor, Boolean.valueOf(true), "templateId", Integer.valueOf(30), Boolean.valueOf(true));
    }

    private void activateFactor() {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
        ActivateFactorRequest activateFactorRequest = new ActivateFactorRequest();
        activateFactorRequest.setPassCode("123456");
        UserFactor activatedUserFactor = userFactorApi.activateFactor("userId", "factorId", activateFactorRequest);
    }

    private void verifyFactor() {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
        VerifyFactorRequest verifyFactorRequest = new VerifyFactorRequest();
        verifyFactorRequest.setPassCode("123456");
        VerifyUserFactorResponse verifyUserFactorResponse = userFactorApi.verifyFactor("userId", "factorId", "templateId", Integer.valueOf(10), "xForwardedFor", "userAgent", "acceptLanguage", verifyFactorRequest);
    }

    private void listApplication() {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        List applications = applicationApi.listApplications(null, null, Integer.valueOf(10), null, null, Boolean.valueOf(true));
    }

    private void getApplication() {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        Application app = applicationApi.getApplication("appId", null);
    }

    private void createSwaApplication() {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        SwaApplicationSettingsApplication swaApplicationSettingsApplication = new SwaApplicationSettingsApplication();
        swaApplicationSettingsApplication.buttonField("btn-login").passwordField("txtbox-password").usernameField("txtbox-username").url("https://example.com/login.html");
        SwaApplicationSettings swaApplicationSettings = new SwaApplicationSettings();
        swaApplicationSettings.app(swaApplicationSettingsApplication);
        BrowserPluginApplication browserPluginApplication = new BrowserPluginApplication();
        browserPluginApplication.name("template_swa");
        browserPluginApplication.label("Sample Plugin App");
        browserPluginApplication.settings(swaApplicationSettings);
        BrowserPluginApplication createdApp = (BrowserPluginApplication)applicationApi.createApplication(BrowserPluginApplication.class, (Application)browserPluginApplication, Boolean.valueOf(true), null);
    }

    private void listSysLogs() {
        SystemLogApi systemLogApi = new SystemLogApi(this.client);
        List logEvents = systemLogApi.listLogEvents(null, null, null, "interestingURI.com", Integer.valueOf(100), "ASCENDING", null);
    }

    private void callAnotherEndpoint() {
        ApiClient apiClient = ReadmeSnippets.buildApiClient("orgBaseUrl", "apiKey");
        BookmarkApplication bookmarkApplication = new BookmarkApplication();
        bookmarkApplication.setName("bookmark");
        bookmarkApplication.setLabel("Sample Bookmark App");
        bookmarkApplication.setSignOnMode(ApplicationSignOnMode.BOOKMARK);
        BookmarkApplicationSettings bookmarkApplicationSettings = new BookmarkApplicationSettings();
        BookmarkApplicationSettingsApplication bookmarkApplicationSettingsApplication = new BookmarkApplicationSettingsApplication();
        bookmarkApplicationSettingsApplication.setUrl("https://example.com/bookmark.htm");
        bookmarkApplicationSettingsApplication.setRequestIntegration(Boolean.valueOf(false));
        bookmarkApplicationSettings.setApp(bookmarkApplicationSettingsApplication);
        bookmarkApplication.setSettings(bookmarkApplicationSettings);
        ResponseEntity responseEntity = apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.emptyMap(), null, (Object)bookmarkApplication, new HttpHeaders(), (MultiValueMap)new LinkedMultiValueMap(), null, Collections.singletonList(MediaType.APPLICATION_JSON), MediaType.APPLICATION_JSON, new String[]{"API Token"}, (ParameterizedTypeReference)new ParameterizedTypeReference<BookmarkApplication>(){});
        BookmarkApplication createdApp = (BookmarkApplication)responseEntity.getBody();
    }

    private void paging() {
        UserApi userApi = new UserApi(this.client);
        int pageSize = 2;
        PagedList usersPagedListOne = userApi.listUsersWithPaginationInfo(null, null, Integer.valueOf(pageSize), null, null, null, null);
        String nextPageUrl = usersPagedListOne.getNextPage();
        PagedList usersPagedListTwo = userApi.listUsersWithPaginationInfo("after", null, Integer.valueOf(pageSize), null, null, null, null);
        for (User tmpUser2 : usersPagedListOne.getItems()) {
            log.info("User: {}", (Object)tmpUser2.getProfile().getEmail());
        }
        usersPagedListOne.getItems().forEach(tmpUser -> log.info("User: {}", (Object)tmpUser.getProfile().getEmail()));
    }

    private void complexCaching() {
        Caches.newCacheManager().withDefaultTimeToLive(300L, TimeUnit.SECONDS).withDefaultTimeToIdle(300L, TimeUnit.SECONDS).withCache(Caches.forResource(User.class).withTimeToLive(1L, TimeUnit.HOURS).withTimeToIdle(30L, TimeUnit.MINUTES)).withCache(Caches.forResource(Group.class).withTimeToLive(1L, TimeUnit.HOURS)).build();
    }

    private void disableCaching() {
        ApiClient client = Clients.builder().setCacheManager(Caches.newDisabledCacheManager()).build();
    }

    private static ApiClient buildApiClient(String orgBaseUrl, String apiKey) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(orgBaseUrl);
        apiClient.setApiKey(apiKey);
        apiClient.setApiKeyPrefix("SSWS");
        return apiClient;
    }
}

