/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.authorization.server;

import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleList;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import com.okta.sdk.resource.policy.PolicyType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * AuthorizationServerPolicy
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2023-07-07T08:49:59.755-05:00")
public interface AuthorizationServerPolicy extends ExtensibleResource {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    PolicyRuleConditions getConditions();

    AuthorizationServerPolicy setConditions(PolicyRuleConditions conditions);

    Date getCreated();

    String getDescription();

    AuthorizationServerPolicy setDescription(String description);

    String getId();

    Date getLastUpdated();

    String getName();

    AuthorizationServerPolicy setName(String name);

    Integer getPriority();

    AuthorizationServerPolicy setPriority(Integer priority);

    StatusEnum getStatus();

    AuthorizationServerPolicy setStatus(StatusEnum status);

    /**
    * Enum status
    */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),
        
        INACTIVE("INACTIVE");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }

    Boolean getSystem();

    AuthorizationServerPolicy setSystem(Boolean system);

    PolicyType getType();

    AuthorizationServerPolicy setType(PolicyType type);


    /**
    * 
    * Returns a Policy Rule by ID that is defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @param ruleId  (required)
    * @return AuthorizationServerPolicyRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    AuthorizationServerPolicyRule getPolicyRule(String authServerId, String ruleId);


    /**
    * 
    * Deactivate Authorization Server Policy
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate")
    void deactivate(String authServerId);


    /**
    * 
    * Creates a policy rule for the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @param policyRule  (required)
    * @return AuthorizationServerPolicyRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules")
    AuthorizationServerPolicyRule createPolicyRule(String authServerId, AuthorizationServerPolicyRule policyRule);


    /**
    * 
    * Success
    * @param authServerId  (required)
    * @return AuthorizationServerPolicy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    AuthorizationServerPolicy update(String authServerId);


    /**
    * 
    * Success
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    void delete(String authServerId);


    /**
    * 
    * Enumerates all policy rules for the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @return AuthorizationServerPolicyRuleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules")
    AuthorizationServerPolicyRuleList listPolicyRules(String authServerId);


    /**
    * 
    * Activate Authorization Server Policy
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate")
    void activate(String authServerId);


    /**
    * 
    * Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @param ruleId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    void deletePolicyRule(String authServerId, String ruleId);


}

