/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.9.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.user;

import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.ResponseLinksList;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.type.UserType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * User
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2021-12-15T06:35:21.151-06:00")
public interface User extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    Date getActivated();

    Date getCreated();

    UserCredentials getCredentials();

    User setCredentials(UserCredentials credentials);

    String getId();

    Date getLastLogin();

    Date getLastUpdated();

    Date getPasswordChanged();

    UserProfile getProfile();

    User setProfile(UserProfile profile);

    UserStatus getStatus();

    Date getStatusChanged();

    UserStatus getTransitioningToStatus();

    UserType getType();

    User setType(UserType type);


    /**
    * Listing IdPs associated with a user
    * Lists the IdPs associated with the user.
    * @return IdentityProviderList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/idps")
    IdentityProviderList listIdentityProviders();


    /**
    * Deactivate User
    * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    * @param sendEmail  (optional, default to false)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    void deactivate(Boolean sendEmail);

    /**
    * Deactivate User
    * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    void deactivate();

    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @param sendEmail  (required)
    * @return ResetPasswordToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    ResetPasswordToken resetPassword(Boolean sendEmail);


    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; and the user&#39;s password is reset to a temporary password that is returned.
    * @return TempPassword
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password?tempPassword&#x3D;true")
    TempPassword expirePasswordAndGetTemporaryPassword();


    /**
    * Enroll Factor
    * Enrolls a user with a supported factor.
    * @param body Factor (required)
    * @param updatePhone  (optional, default to false)
    * @param templateId id of SMS template (only for SMS factor) (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @param activate  (optional, default to false)
    * @return UserFactor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/factors")
    UserFactor enrollFactor(UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate);

    /**
    * Enroll Factor
    * Enrolls a user with a supported factor.
    * @param body Factor (required)
    * @return UserFactor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/factors")
    UserFactor enrollFactor(UserFactor body);

    /**
    * 
    * Enumerates all the enrolled factors for the specified user
    * @return UserFactorList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/factors")
    UserFactorList listFactors();


    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password
    * @param sendEmail  (optional, default to true)
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPasswordGenerateOneTimeToken(Boolean sendEmail);

    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPasswordGenerateOneTimeToken();

    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    * @param oAuthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/sessions")
    void clearSessions(Boolean oAuthTokens);

    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/sessions")
    void clearSessions();

    /**
    * 
    * Success
    * @param roleId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps")
    void addAllAppsAsTarget(String roleId);


    /**
    * Forgot Password
    * Sets a new password for a user by validating the user&#39;s answer to their current recovery question
    * @param user  (required)
    * @param sendEmail  (optional, default to true)
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user, Boolean sendEmail);

    /**
    * Forgot Password
    * Sets a new password for a user by validating the user&#39;s answer to their current recovery question
    * @param user  (required)
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user);

    /**
    * 
    * Revokes all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/tokens")
    void revokeTokensForUserAndClient(String clientId);


    /**
    * Reset Factors
    * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reset_factors")
    void resetFactors();


    /**
    * 
    * Get linked objects for a user, relationshipName can be a primary or associated relationship name
    * @param relationshipName  (required)
    * @return ResponseLinksList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/linkedObjects/{relationshipName}")
    ResponseLinksList getLinkedObjects(String relationshipName);


    /**
    * 
    * Revokes all grants for a specified user
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/grants")
    void revokeGrants();


    /**
    * 
    * Success
    * @param roleId  (required)
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/groups")
    GroupList listGroupTargets(String roleId);


    /**
    * 
    * Gets a refresh token issued for the specified User and Client.
    * @param clientId  (required)
    * @param tokenId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId, String expand);

    /**
    * 
    * Gets a refresh token issued for the specified User and Client.
    * @param clientId  (required)
    * @param tokenId  (required)
    * @return OAuth2RefreshToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId);

    /**
    * 
    * Revokes all grants for the specified user and client
    * @param clientId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/grants")
    void revokeGrantsForUserAndClient(String clientId);


    /**
    * 
    * Unassigns a role from a user.
    * @param roleId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}")
    void removeRole(String roleId);


    /**
    * 
    * Revokes the specified refresh token.
    * @param clientId  (required)
    * @param tokenId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    void revokeTokenForUserAndClient(String clientId, String tokenId);


    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password?tempPassword&#x3D;false")
    User expirePassword();


    /**
    * Activate User
    * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation. The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
    * @param sendEmail Sends an activation email to the user if true (required)
    * @return UserActivationToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/activate")
    UserActivationToken activate(Boolean sendEmail);


    /**
    * Change Recovery Question
    * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
    * @param userCredentials  (required)
    * @return UserCredentials
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/change_recovery_question")
    UserCredentials changeRecoveryQuestion(UserCredentials userCredentials);


    /**
    * 
    * Lists all grants for the specified user
    * @param scopeId  (optional)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrantList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/grants")
    OAuth2ScopeConsentGrantList listGrants(String scopeId, String expand);

    /**
    * 
    * Lists all grants for the specified user
    * @return OAuth2ScopeConsentGrantList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/grants")
    OAuth2ScopeConsentGrantList listGrants();

    /**
    * Unsuspend User
    * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/unsuspend")
    void unsuspend();


    /**
    * 
    * Assigns a role to a user.
    * @param assignRoleRequest  (required)
    * @param disableNotifications  (optional)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/roles")
    Role assignRole(AssignRoleRequest assignRoleRequest, Boolean disableNotifications);

    /**
    * 
    * Assigns a role to a user.
    * @param assignRoleRequest  (required)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/roles")
    Role assignRole(AssignRoleRequest assignRoleRequest);

    /**
    * 
    * Gets role that is assigne to user.
    * @param roleId  (required)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/roles/{roleId}")
    Role getRole(String roleId);


    /**
    * Get Member Groups
    * Fetches the groups of which the user is a member.
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/groups")
    GroupList listGroups();


    /**
    * 
    * Lists all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshTokenList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens")
    OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId, String expand);

    /**
    * 
    * Lists all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    * @return OAuth2RefreshTokenList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens")
    OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId);

    /**
    * 
    * Success
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    void removeGroupTarget(String roleId, String groupId);


    /**
    * 
    * Enumerates all the supported factors that can be enrolled for the specified user
    * @return UserFactorList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/factors/catalog")
    UserFactorList listSupportedFactors();


    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    * @param sendEmail  (optional, default to false)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}")
    void delete(Boolean sendEmail);

    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}")
    void delete();

    /**
    * 
    * Lists all client resources for which the specified user has grants or tokens.
    * @return OAuth2ClientList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/clients")
    OAuth2ClientList listClients();


    /**
    * Suspend User
    * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/suspend")
    void suspend();


    /**
    * 
    * Revokes one grant for a specified user
    * @param grantId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/grants/{grantId}")
    void revokeGrant(String grantId);


    /**
    * 
    * 
    * @param primaryRelationshipName  (required)
    * @param primaryUserId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/users/{associatedUserId}/linkedObjects/{primaryRelationshipName}/{primaryUserId}")
    void setLinkedObject(String primaryRelationshipName, String primaryUserId);


    /**
    * 
    * Delete linked objects for a user, relationshipName can be ONLY a primary relationship name
    * @param relationshipName  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/linkedObjects/{relationshipName}")
    void removeLinkedObject(String relationshipName);


    /**
    * Unlock User
    * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/unlock")
    void unlock();


    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @param strict  (optional)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/users/{userId}")
    User update(Boolean strict);

    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/users/{userId}")
    User update();

    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    * @param factorId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    void deleteFactor(String factorId);


    /**
    * Reactivate User
    * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
    * @param sendEmail Sends an activation email to the user if true (optional, default to false)
    * @return UserActivationToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reactivate")
    UserActivationToken reactivate(Boolean sendEmail);

    /**
    * Reactivate User
    * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
    * @return UserActivationToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reactivate")
    UserActivationToken reactivate();

    /**
    * 
    * Fetches a factor for the specified user
    * @param factorId  (required)
    * @return UserFactor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/factors/{factorId}")
    UserFactor getFactor(String factorId);


    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
    * @param changePasswordRequest  (required)
    * @param strict  (optional)
    * @return UserCredentials
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, Boolean strict);

    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
    * @param changePasswordRequest  (required)
    * @return UserCredentials
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    UserCredentials changePassword(ChangePasswordRequest changePasswordRequest);

    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @return AppLinkList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/appLinks")
    AppLinkList listAppLinks();


    /**
    * 
    * Success
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    void addGroupTarget(String roleId, String groupId);


    /**
    * 
    * Enumerates all available security questions for a user&#39;s &#x60;question&#x60; factor
    * @return SecurityQuestionList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/factors/questions")
    SecurityQuestionList listSupportedSecurityQuestions();


    /**
    * Add User to Group
    * Adds a user to a group with &#39;OKTA_GROUP&#39; type.
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/groups/{groupId}/users/{userId}")
    void addToGroup(String groupId);


    /**
    * 
    * Lists all roles assigned to a user.
    * @param expand  (optional)
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/roles")
    RoleList listAssignedRoles(String expand);

    /**
    * 
    * Lists all roles assigned to a user.
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/users/{userId}/roles")
    RoleList listAssignedRoles();

}

