/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.9.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.authorization.server;

import com.okta.sdk.resource.application.AuthorizationServerCredentials;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.JwkUse;
import com.okta.sdk.resource.application.OAuth2Claim;
import com.okta.sdk.resource.application.OAuth2ClaimList;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2Scope;
import com.okta.sdk.resource.application.OAuth2ScopeList;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicyList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * AuthorizationServer
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2021-12-15T06:35:21.151-06:00")
public interface AuthorizationServer extends ExtensibleResource, Deletable {

    Map<String, Object> getLinks();

    List<String> getAudiences();

    AuthorizationServer setAudiences(List<String> audiences);

    Date getCreated();

    AuthorizationServerCredentials getCredentials();

    AuthorizationServer setCredentials(AuthorizationServerCredentials credentials);

    String getDescription();

    AuthorizationServer setDescription(String description);

    String getId();

    String getIssuer();

    AuthorizationServer setIssuer(String issuer);

    IssuerModeEnum getIssuerMode();

    AuthorizationServer setIssuerMode(IssuerModeEnum issuerMode);

    /**
    * Enum issuerMode
    */
    public enum IssuerModeEnum {
        ORG_URL("ORG_URL"),
        
        CUSTOM_URL("CUSTOM_URL");

        private String value;

        IssuerModeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }

    Date getLastUpdated();

    String getName();

    AuthorizationServer setName(String name);

    StatusEnum getStatus();

    AuthorizationServer setStatus(StatusEnum status);

    /**
    * Enum status
    */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),
        
        INACTIVE("INACTIVE");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }


    /**
    * 
    * Success
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/lifecycle/activate")
    void activate();


    /**
    * 
    * Success
    * @param claimId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    void deleteOAuth2Claim(String claimId);


    /**
    * 
    * Success
    * @param oAuth2Scope  (required)
    * @return OAuth2Scope
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/scopes")
    OAuth2Scope createOAuth2Scope(OAuth2Scope oAuth2Scope);


    /**
    * 
    * Success
    * @param scopeId  (required)
    * @return OAuth2Scope
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    OAuth2Scope getOAuth2Scope(String scopeId);


    /**
    * 
    * Success
    * @param policy  (required)
    * @return AuthorizationServerPolicy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies")
    AuthorizationServerPolicy createPolicy(AuthorizationServerPolicy policy);


    /**
    * 
    * Success
    * @return AuthorizationServerPolicyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/policies")
    AuthorizationServerPolicyList listPolicies();


    /**
    * 
    * Success
    * @return OAuth2ClaimList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/claims")
    OAuth2ClaimList listOAuth2Claims();


    /**
    * 
    * Success
    * @param claimId  (required)
    * @return OAuth2Claim
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    OAuth2Claim getOAuth2Claim(String claimId);


    /**
    * 
    * Success
    * @return OAuth2ClientList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/clients")
    OAuth2ClientList listOAuth2Clients();


    /**
    * 
    * Success
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/lifecycle/deactivate")
    void deactivate();


    /**
    * 
    * Success
    * @param scopeId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    void deleteOAuth2Scope(String scopeId);


    /**
    * 
    * Success
    * @return JsonWebKeyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/credentials/keys")
    JsonWebKeyList listKeys();


    /**
    * 
    * Success
    * @param q  (optional)
    * @param filter  (optional)
    * @param cursor  (optional)
    * @return OAuth2ScopeList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes")
    OAuth2ScopeList listOAuth2Scopes(String q, String filter, String cursor);

    /**
    * 
    * Success
    * @return OAuth2ScopeList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes")
    OAuth2ScopeList listOAuth2Scopes();

    /**
    * 
    * Success
    * @param clientId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    void revokeRefreshTokensForClient(String clientId);


    /**
    * 
    * Success
    * @param use  (required)
    * @return JsonWebKeyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate")
    JsonWebKeyList rotateKeys(JwkUse use);


    /**
    * 
    * Success
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshTokenList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    OAuth2RefreshTokenList listRefreshTokensForClient(String clientId, String expand);

    /**
    * 
    * Success
    * @param clientId  (required)
    * @return OAuth2RefreshTokenList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    OAuth2RefreshTokenList listRefreshTokensForClient(String clientId);

    /**
    * 
    * Success
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}")
    void delete();


    /**
    * 
    * Success
    * @param claimId  (required)
    * @param oAuth2Claim  (required)
    * @return OAuth2Claim
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    OAuth2Claim updateOAuth2Claim(String claimId, OAuth2Claim oAuth2Claim);


    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId, String expand);

    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    * @return OAuth2RefreshToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId);

    /**
    * 
    * Success
    * @param policyId  (required)
    * @param policy  (required)
    * @return AuthorizationServerPolicy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    AuthorizationServerPolicy updatePolicy(String policyId, AuthorizationServerPolicy policy);


    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    void revokeRefreshTokenForClient(String clientId, String tokenId);


    /**
    * 
    * Success
    * @param policyId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    void deletePolicy(String policyId);


    /**
    * 
    * Success
    * @param policyId  (required)
    * @return AuthorizationServerPolicy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    AuthorizationServerPolicy getPolicy(String policyId);


    /**
    * 
    * Success
    * @return AuthorizationServer
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}")
    AuthorizationServer update();


    /**
    * 
    * Success
    * @param scopeId  (required)
    * @param oAuth2Scope  (required)
    * @return OAuth2Scope
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    OAuth2Scope updateOAuth2Scope(String scopeId, OAuth2Scope oAuth2Scope);


    /**
    * 
    * Success
    * @param oAuth2Claim  (required)
    * @return OAuth2Claim
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-12-15T06:35:21.151-06:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/claims")
    OAuth2Claim createOAuth2Claim(OAuth2Claim oAuth2Claim);


}

